/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.config;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import snownee.jade.Jade;
import snownee.jade.api.IToggleableProvider;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.impl.config.entry.ConfigEntry;
import snownee.jade.util.JsonConfig;
import snownee.jade.util.PlatformProxy;

public class PluginConfig
implements IPluginConfig {
    public static final PluginConfig INSTANCE = new PluginConfig();
    public static final String CLIENT_FILE = "jade/plugins.json";
    public static final String SERVER_FILE = "jade/server-plugin-overrides.json";
    private final Map<ResourceLocation, ConfigEntry<Object>> configs = Maps.newHashMap();
    private JsonObject serverConfigs;

    private PluginConfig() {
    }

    public void addConfig(ConfigEntry<?> entry) {
        Preconditions.checkArgument((StringUtils.countMatches((CharSequence)entry.getId().m_135815_(), (char)'.') <= 1 ? 1 : 0) != 0);
        Preconditions.checkArgument((!this.containsKey(entry.getId()) ? 1 : 0) != 0, (String)"Duplicate config key: {}", (Object)entry.getId());
        this.configs.put(entry.getId(), entry);
    }

    @Override
    public Set<ResourceLocation> getKeys(String namespace) {
        return this.getKeys().stream().filter(id -> id.m_135827_().equals(namespace)).collect(Collectors.toSet());
    }

    @Override
    public Set<ResourceLocation> getKeys() {
        return this.configs.keySet();
    }

    @Override
    public boolean get(IToggleableProvider provider) {
        if (provider.isRequired()) {
            return true;
        }
        return this.get(provider.getUid(), provider.enabledByDefault());
    }

    @Override
    public boolean get(ResourceLocation key, boolean defaultValue) {
        if (PlatformProxy.isPhysicallyClient()) {
            ConfigEntry<?> entry = this.getEntry(key);
            return entry == null ? defaultValue : (Boolean)entry.getValue();
        }
        return Optional.ofNullable(this.serverConfigs).map($ -> $.getAsJsonObject(key.m_135827_())).map($ -> $.get(key.m_135815_())).map(JsonElement::getAsBoolean).orElse(false);
    }

    @Override
    public <T extends Enum<T>> T getEnum(ResourceLocation key) {
        return (T)((Enum)this.getEntry(key).getValue());
    }

    @Override
    public int getInt(ResourceLocation key) {
        return (Integer)this.getEntry(key).getValue();
    }

    @Override
    public float getFloat(ResourceLocation key) {
        return ((Float)this.getEntry(key).getValue()).floatValue();
    }

    @Override
    public String getString(ResourceLocation key) {
        return (String)this.getEntry(key).getValue();
    }

    public List<String> getNamespaces() {
        return this.configs.keySet().stream().sorted((o1, o2) -> o1.m_135827_().compareToIgnoreCase(o2.m_135827_())).map(ResourceLocation::m_135827_).distinct().collect(Collectors.toList());
    }

    public ConfigEntry<?> getEntry(ResourceLocation key) {
        return this.configs.get(key);
    }

    public boolean set(ResourceLocation key, Object value) {
        Objects.requireNonNull(value);
        ConfigEntry<?> entry = this.getEntry(key);
        if (entry == null) {
            Jade.LOGGER.warn("Skip setting value for unknown option: {}, {}", (Object)key, value);
            return false;
        }
        if (!entry.isValidValue(value)) {
            Jade.LOGGER.warn("Skip setting illegal value for option: {}, {}", (Object)key, value);
            return false;
        }
        entry.setValue(value);
        return true;
    }

    public File getFile() {
        boolean client = PlatformProxy.isPhysicallyClient();
        return new File(PlatformProxy.getConfigDirectory(), client ? CLIENT_FILE : SERVER_FILE);
    }

    public void reload() {
        boolean client = PlatformProxy.isPhysicallyClient();
        File configFile = this.getFile();
        if (client) {
            this.configs.values().forEach($ -> $.setSynced(false));
        }
        if (!configFile.exists()) {
            this.writeConfig(configFile, true);
        }
        if (client) {
            Map config;
            try (FileReader reader = new FileReader(configFile, StandardCharsets.UTF_8);){
                config = (Map)JsonConfig.DEFAULT_GSON.fromJson((Reader)reader, new TypeToken<Map<String, Map<String, Object>>>(){}.getType());
            }
            catch (Exception e) {
                e.printStackTrace();
                config = Maps.newHashMap();
            }
            MutableBoolean saveFlag = new MutableBoolean();
            HashSet found = Sets.newHashSet();
            config.forEach((namespace, subMap) -> subMap.forEach((path, value) -> {
                ResourceLocation id = new ResourceLocation(namespace, path);
                if (!this.configs.containsKey(id)) {
                    return;
                }
                if (!this.set(id, value)) {
                    saveFlag.setTrue();
                }
                found.add(id);
            }));
            Set<ResourceLocation> allKeys = this.getKeys();
            for (ResourceLocation id : allKeys) {
                if (found.contains(id)) continue;
                this.set(id, this.getEntry(id).getDefaultValue());
                saveFlag.setTrue();
            }
            if (saveFlag.isTrue()) {
                this.save();
            }
        } else {
            try (FileReader reader = new FileReader(configFile, StandardCharsets.UTF_8);){
                this.serverConfigs = (JsonObject)JsonConfig.DEFAULT_GSON.fromJson((Reader)reader, JsonObject.class);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.serverConfigs = null;
            }
        }
    }

    public void save() {
        this.writeConfig(this.getFile(), false);
    }

    private void writeConfig(File file, boolean reset) {
        String json;
        boolean client = PlatformProxy.isPhysicallyClient();
        if (client) {
            HashMap config = Maps.newHashMap();
            this.configs.values().forEach(e -> {
                Map modConfig = config.computeIfAbsent(e.getId().m_135827_(), k -> Maps.newHashMap());
                if (reset) {
                    e.setValue(e.getDefaultValue());
                }
                modConfig.put(e.getId().m_135815_(), e.getValue());
            });
            json = JsonConfig.DEFAULT_GSON.toJson((Object)config);
        } else {
            json = "{}";
        }
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try (FileWriter writer = new FileWriter(file, StandardCharsets.UTF_8);){
            writer.write(json);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public IWailaConfig getWailaConfig() {
        return Jade.CONFIG.get();
    }

    public void applyServerConfigs(JsonObject json) {
        json.keySet().forEach(namespace -> json.getAsJsonObject(namespace).entrySet().forEach(entry -> {
            ResourceLocation key = new ResourceLocation(namespace, (String)entry.getKey());
            ConfigEntry<?> configEntry = this.getEntry(key);
            if (configEntry != null) {
                Object v;
                JsonPrimitive primitive = ((JsonElement)entry.getValue()).getAsJsonPrimitive();
                if (primitive.isBoolean()) {
                    v = primitive.getAsBoolean();
                } else if (primitive.isNumber()) {
                    v = primitive.getAsNumber();
                } else if (primitive.isString()) {
                    v = primitive.getAsString();
                } else {
                    return;
                }
                if (configEntry.isValidValue(v)) {
                    configEntry.setValue(v);
                    configEntry.setSynced(true);
                }
            }
        }));
    }

    public String getServerConfigs() {
        return this.serverConfigs == null ? "" : this.serverConfigs.toString();
    }

    public boolean containsKey(ResourceLocation uid) {
        return this.configs.containsKey(uid);
    }
}

