/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.impl.HierarchyLookup;
import snownee.jade.impl.PriorityStore;

public class WailaCommonRegistration
implements IWailaCommonRegistration {
    public static final WailaCommonRegistration INSTANCE = new WailaCommonRegistration();
    public final HierarchyLookup<IServerDataProvider<BlockEntity>> blockDataProviders = new HierarchyLookup(BlockEntity.class);
    public final HierarchyLookup<IServerDataProvider<Entity>> entityDataProviders = new HierarchyLookup(Entity.class);
    public final PriorityStore<IJadeProvider> priorities = new PriorityStore<IJadeProvider>("jade/sort-order", IJadeProvider::getDefaultPriority, IJadeProvider::getUid);
    public final HierarchyLookup<IServerExtensionProvider<Object, ItemStack>> itemStorageProviders = new HierarchyLookup(Object.class, true);
    public final HierarchyLookup<IServerExtensionProvider<Object, CompoundTag>> fluidStorageProviders = new HierarchyLookup(Object.class, true);
    public final HierarchyLookup<IServerExtensionProvider<Object, CompoundTag>> energyStorageProviders = new HierarchyLookup(Object.class, true);
    public final HierarchyLookup<IServerExtensionProvider<Object, CompoundTag>> progressProviders = new HierarchyLookup(Object.class, true);

    WailaCommonRegistration() {
    }

    @Override
    public void registerBlockDataProvider(IServerDataProvider<BlockEntity> dataProvider, Class<? extends BlockEntity> block) {
        this.blockDataProviders.register(block, dataProvider);
    }

    @Override
    public void registerEntityDataProvider(IServerDataProvider<Entity> dataProvider, Class<? extends Entity> entity) {
        this.entityDataProviders.register(entity, dataProvider);
    }

    public List<IServerDataProvider<BlockEntity>> getBlockNBTProviders(BlockEntity block) {
        return this.blockDataProviders.get(block);
    }

    public List<IServerDataProvider<Entity>> getEntityNBTProviders(Entity entity) {
        return this.entityDataProviders.get(entity);
    }

    public void loadComplete() {
        this.blockDataProviders.loadComplete(this.priorities);
        this.entityDataProviders.loadComplete(this.priorities);
        this.itemStorageProviders.loadComplete(this.priorities);
        this.fluidStorageProviders.loadComplete(this.priorities);
        this.energyStorageProviders.loadComplete(this.priorities);
        this.progressProviders.loadComplete(this.priorities);
    }

    @Override
    public <T> void registerItemStorage(IServerExtensionProvider<T, ItemStack> provider, Class<? extends T> clazz) {
        this.itemStorageProviders.register(clazz, provider);
    }

    @Override
    public <T> void registerFluidStorage(IServerExtensionProvider<T, CompoundTag> provider, Class<? extends T> clazz) {
        this.fluidStorageProviders.register(clazz, provider);
    }

    @Override
    public <T> void registerEnergyStorage(IServerExtensionProvider<T, CompoundTag> provider, Class<? extends T> clazz) {
        this.energyStorageProviders.register(clazz, provider);
    }

    @Override
    public <T> void registerProgress(IServerExtensionProvider<T, CompoundTag> provider, Class<? extends T> clazz) {
        this.progressProviders.register(clazz, provider);
    }
}

