/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.entity.AnimBlockSummon;
import com.hollingsworth.arsnouveau.common.entity.EnchantedFallingBlock;
import com.hollingsworth.arsnouveau.common.lib.GlyphLib;
import java.util.Set;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;

public class EffectAnimate
extends AbstractEffect {
    public static EffectAnimate INSTANCE = new EffectAnimate();

    public EffectAnimate() {
        super(GlyphLib.EffectAnimateID, "Animate Block");
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        BlockState state = world.m_8055_(rayTraceResult.m_82425_());
        if (EnchantedFallingBlock.canFall(world, rayTraceResult.m_82425_(), shooter, spellStats)) {
            this.animateBlock((HitResult)rayTraceResult, rayTraceResult.m_82450_(), world, shooter, spellStats, spellContext, state);
            world.m_7731_(rayTraceResult.m_82425_(), state.m_60819_().m_76188_(), 3);
        }
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        EnchantedFallingBlock fallingBlock;
        Entity entity = rayTraceResult.m_82443_();
        if (entity instanceof EnchantedFallingBlock && !(fallingBlock = (EnchantedFallingBlock)entity).m_213877_()) {
            AnimBlockSummon summon = this.animateBlock((HitResult)rayTraceResult, fallingBlock.f_19825_, world, shooter, spellStats, spellContext, fallingBlock.getBlockState());
            summon.m_20256_(fallingBlock.m_20184_());
            summon.f_19864_ = true;
            summon.f_19789_ = 0.0f;
            fallingBlock.m_146870_();
        }
    }

    private AnimBlockSummon animateBlock(HitResult rayTraceResult, Vec3 pos, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, BlockState state) {
        AnimBlockSummon blockSummon = new AnimBlockSummon(world, state);
        blockSummon.setColor(spellContext.getColors().getColor());
        blockSummon.m_146884_(pos);
        int ticks = (int)(20.0 * ((double)((Integer)this.GENERIC_INT.get()).intValue() + (double)((Integer)this.EXTEND_TIME.get()).intValue() * spellStats.getDurationMultiplier()));
        blockSummon.setTicksLeft(ticks);
        blockSummon.m_6710_(shooter.m_21214_());
        blockSummon.m_21561_(true);
        blockSummon.m_7105_(true);
        if (shooter instanceof Player) {
            Player player = (Player)shooter;
            blockSummon.m_21828_(player);
        }
        this.summonLivingEntity(rayTraceResult, world, shooter, spellStats, spellContext, blockSummon);
        return blockSummon;
    }

    @Override
    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addGenericInt(builder, 60, "Base duration in seconds", "duration");
        this.addExtendTimeConfig(builder, 60);
    }

    @Override
    public int getDefaultManaCost() {
        return 100;
    }

    @Override
    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    @Override
    public String getBookDescription() {
        return "Animate a block to fight for you.";
    }

    @Override
    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return this.getSummonAugments();
    }

    @Override
    @NotNull
    protected Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.MANIPULATION, SpellSchools.CONJURATION);
    }
}

