/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.capability.CapabilityRegistry;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class PacketUpdateMana {
    public double mana;
    public int maxMana;
    public int glyphBonus;
    public int tierBonus;

    public PacketUpdateMana(FriendlyByteBuf buf) {
        this.mana = buf.readDouble();
        this.maxMana = buf.readInt();
        this.glyphBonus = buf.readInt();
        this.tierBonus = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeDouble(this.mana);
        buf.writeInt(this.maxMana);
        buf.writeInt(this.glyphBonus);
        buf.writeInt(this.tierBonus);
    }

    public PacketUpdateMana(double mana, int maxMana, int glyphBonus, int tierBonus) {
        this.mana = mana;
        this.maxMana = maxMana;
        this.glyphBonus = glyphBonus;
        this.tierBonus = tierBonus;
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (ArsNouveau.proxy.getPlayer() == null) {
                return;
            }
            CapabilityRegistry.getMana((LivingEntity)ArsNouveau.proxy.getPlayer()).ifPresent(mana -> {
                mana.setMana(this.mana);
                mana.setMaxMana(this.maxMana);
                mana.setGlyphBonus(this.glyphBonus);
                mana.setBookTier(this.tierBonus);
            });
        });
        ctx.get().setPacketHandled(true);
    }
}

