/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.common.block.tile.IAnimationListener;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.entity.SummonWolf;
import com.hollingsworth.arsnouveau.common.entity.goal.wilden.WildenMeleeAttack;
import com.hollingsworth.arsnouveau.common.entity.goal.wilden.WildenRamAttack;
import com.hollingsworth.arsnouveau.common.entity.goal.wilden.WildenSummon;
import com.hollingsworth.arsnouveau.setup.Config;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import software.bernie.ars_nouveau.geckolib3.core.IAnimatable;
import software.bernie.ars_nouveau.geckolib3.core.PlayState;
import software.bernie.ars_nouveau.geckolib3.core.builder.AnimationBuilder;
import software.bernie.ars_nouveau.geckolib3.core.controller.AnimationController;
import software.bernie.ars_nouveau.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.ars_nouveau.geckolib3.core.manager.AnimationData;
import software.bernie.ars_nouveau.geckolib3.core.manager.AnimationFactory;
import software.bernie.ars_nouveau.geckolib3.util.GeckoLibUtil;

public class WildenHunter
extends Monster
implements IAnimatable,
IAnimationListener {
    AnimationFactory manager = GeckoLibUtil.createFactory(this);
    public int ramCooldown = 0;
    public int summonCooldown = 0;
    AnimationController<WildenHunter> controller;

    public WildenHunter(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
    }

    public WildenHunter(Level worldIn) {
        this((EntityType<? extends Monster>)((EntityType)ModEntities.WILDEN_HUNTER.get()), worldIn);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(5, (Goal)new WildenMeleeAttack((PathfinderMob)this, 1.3, true, Animations.ATTACK.ordinal(), () -> true));
        this.f_21345_.m_25352_(3, (Goal)new WildenRamAttack((PathfinderMob)this, 2.0, true));
        this.f_21345_.m_25352_(3, (Goal)new WildenSummon(this));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        if (((Boolean)Config.HUNTER_ATTACK_ANIMALS.get()).booleanValue()) {
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, 10, true, false, entity -> !(entity instanceof SummonWolf) || !((SummonWolf)entity).isWildenSummon));
        }
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12621_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12618_;
    }

    public int m_213860_() {
        return 5;
    }

    protected float m_6121_() {
        return 0.4f;
    }

    public void m_5496_(SoundEvent soundIn, float volume, float pitch) {
        super.m_5496_(soundIn, volume, pitch - 0.5f);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12619_;
    }

    public static AttributeSupplier.Builder getModdedAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22278_, (double)0.6f).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22281_, 4.5).m_22268_(Attributes.f_22284_, 2.0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            return;
        }
        if (this.ramCooldown > 0) {
            --this.ramCooldown;
        }
        if (this.summonCooldown > 0) {
            --this.summonCooldown;
        }
    }

    @Override
    public void startAnimation(int arg) {
        try {
            if (this.controller == null) {
                return;
            }
            if (arg == Animations.ATTACK.ordinal()) {
                if (this.controller.getCurrentAnimation() != null && (this.controller.getCurrentAnimation().animationName.equals("attack") || this.controller.getCurrentAnimation().animationName.equals("attack2") || this.controller.getCurrentAnimation().animationName.equals("howl"))) {
                    return;
                }
                this.controller.markNeedsReload();
                this.controller.setAnimation(new AnimationBuilder().addAnimation("attack").addAnimation("idle"));
            }
            if (arg == Animations.RAM.ordinal()) {
                if (this.controller.getCurrentAnimation() != null && this.controller.getCurrentAnimation().animationName.equals("attack2")) {
                    return;
                }
                this.controller.markNeedsReload();
                this.controller.setAnimation(new AnimationBuilder().addAnimation("attack2").addAnimation("idle"));
            }
            if (arg == Animations.HOWL.ordinal()) {
                this.controller.markNeedsReload();
                this.controller.setAnimation(new AnimationBuilder().addAnimation("howl").addAnimation("idle"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private PlayState attackPredicate(AnimationEvent<?> event) {
        return PlayState.CONTINUE;
    }

    @Override
    public void registerControllers(AnimationData animationData) {
        this.controller = new AnimationController<WildenHunter>(this, "attackController", 1.0f, this::attackPredicate);
        animationData.addAnimationController(this.controller);
    }

    @Override
    public AnimationFactory getFactory() {
        return this.manager;
    }

    public static enum Animations {
        ATTACK,
        RAM,
        HOWL;

    }
}

