/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.block.tile.MageBlockTile;
import com.hollingsworth.arsnouveau.common.datagen.BlockTagProvider;
import com.hollingsworth.arsnouveau.common.entity.ColoredProjectile;
import com.hollingsworth.arsnouveau.common.entity.EnchantedMageblock;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ConcretePowderBlock;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;
import software.bernie.ars_nouveau.geckolib3.core.IAnimatable;
import software.bernie.ars_nouveau.geckolib3.core.manager.AnimationData;
import software.bernie.ars_nouveau.geckolib3.core.manager.AnimationFactory;
import software.bernie.ars_nouveau.geckolib3.util.GeckoLibUtil;

public class EnchantedFallingBlock
extends ColoredProjectile
implements IAnimatable {
    public static final EntityDataAccessor<Boolean> SHOULD_COLOR = SynchedEntityData.m_135353_(EnchantedFallingBlock.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Logger LOGGER = LogUtils.getLogger();
    public BlockState blockState = Blocks.f_49992_.m_49966_();
    public int time;
    public boolean dropItem = true;
    public boolean cancelDrop;
    private boolean hurtEntities;
    private int fallDamageMax = 40;
    private float fallDamagePerDistance;
    public int knockback = 2;
    @Nullable
    public CompoundTag blockData;
    public SpellContext context;
    public float baseDamage;
    protected static final EntityDataAccessor<BlockPos> DATA_START_POS = SynchedEntityData.m_135353_(EnchantedFallingBlock.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private IntOpenHashSet piercingIgnoreEntityIds = new IntOpenHashSet(5);

    public EnchantedFallingBlock(EntityType<? extends ColoredProjectile> p_31950_, Level p_31951_) {
        super(p_31950_, p_31951_);
    }

    public EnchantedFallingBlock(Level world, double v, double y, double v1, BlockState blockState) {
        this((EntityType<? extends ColoredProjectile>)((EntityType)ModEntities.ENCHANTED_FALLING_BLOCK.get()), world);
        this.blockState = blockState;
        this.f_19850_ = true;
        this.m_6034_(v, y, v1);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = v;
        this.f_19855_ = y;
        this.f_19856_ = v1;
        this.setStartPos(this.m_20183_());
    }

    public EnchantedFallingBlock(Level world, BlockPos pos, BlockState blockState) {
        this(world, pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), blockState);
    }

    public static boolean canFall(Level level, BlockPos pos, LivingEntity owner, SpellStats spellStats) {
        if (level.m_46859_(pos) || level.m_7702_(pos) != null && !(level.m_7702_(pos) instanceof MageBlockTile)) {
            return false;
        }
        return BlockUtil.canBlockBeHarvested(spellStats, level, pos) && BlockUtil.destroyRespectsClaim(owner, level, pos);
    }

    @Nullable
    public static EnchantedFallingBlock fall(Level level, BlockPos pos, LivingEntity owner, SpellContext context, SpellResolver resolver, SpellStats spellStats) {
        EnchantedFallingBlock fallingblockentity;
        if (!EnchantedFallingBlock.canFall(level, pos, owner, spellStats)) {
            return null;
        }
        BlockState blockState = level.m_8055_(pos);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof MageBlockTile) {
            MageBlockTile tile = (MageBlockTile)blockEntity;
            fallingblockentity = new EnchantedMageblock(level, (double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, blockState.m_61138_((Property)BlockStateProperties.f_61362_) ? (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.FALSE) : blockState);
            fallingblockentity.blockData = tile.m_187482_();
            fallingblockentity.setColor(tile.color);
            fallingblockentity.m_20088_().m_135381_(SHOULD_COLOR, (Object)true);
        } else {
            fallingblockentity = new EnchantedFallingBlock(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, blockState.m_61138_((Property)BlockStateProperties.f_61362_) ? (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.FALSE) : blockState);
        }
        level.m_7967_((Entity)fallingblockentity);
        fallingblockentity.m_5602_((Entity)owner);
        fallingblockentity.context = context;
        fallingblockentity.baseDamage = (float)(9.0 + spellStats.getDamageModifier());
        boolean bl = fallingblockentity.dropItem = !blockState.m_204336_(BlockTagProvider.GRAVITY_BLACKLIST);
        if (resolver.hasFocus(ItemsRegistry.SHAPERS_FOCUS.get().m_7968_())) {
            fallingblockentity.hurtEntities = true;
        }
        level.m_7731_(pos, blockState.m_60819_().m_76188_(), 3);
        return fallingblockentity;
    }

    public EntityType<?> m_6095_() {
        return (EntityType)ModEntities.ENCHANTED_FALLING_BLOCK.get();
    }

    public boolean m_7337_(Entity pEntity) {
        return super.m_7337_(pEntity) && !(pEntity instanceof FallingBlockEntity) && !(pEntity instanceof EnchantedFallingBlock) && pEntity != this.m_37282_();
    }

    protected boolean m_5603_(Entity p_37250_) {
        return super.m_5603_(p_37250_) && p_37250_ != this.m_37282_() && !this.piercingIgnoreEntityIds.contains(p_37250_.m_19879_());
    }

    public void m_8119_() {
        EntityHitResult hitEntity;
        super.m_8119_();
        if (this.blockState.m_60795_()) {
            this.m_146870_();
            return;
        }
        Block block = this.blockState.m_60734_();
        ++this.time;
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        if ((hitEntity = this.findHitEntity(this.f_19825_, this.f_19825_.m_82549_(this.m_20184_()))) != null) {
            this.m_5790_(hitEntity);
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (!this.f_19853_.f_46443_) {
            BlockHitResult blockhitresult;
            BlockPos blockpos = this.m_20183_();
            boolean isConcrete = this.blockState.m_60734_() instanceof ConcretePowderBlock;
            boolean isConcreteInWater = isConcrete && this.f_19853_.m_6425_(blockpos).m_205070_(FluidTags.f_13131_);
            double d0 = this.m_20184_().m_82556_();
            if (isConcrete && d0 > 1.0 && (blockhitresult = this.f_19853_.m_45547_(new ClipContext(new Vec3(this.f_19854_, this.f_19855_, this.f_19856_), this.m_20182_(), ClipContext.Block.COLLIDER, ClipContext.Fluid.SOURCE_ONLY, (Entity)this))).m_6662_() != HitResult.Type.MISS && this.f_19853_.m_6425_(blockhitresult.m_82425_()).m_205070_(FluidTags.f_13131_)) {
                blockpos = blockhitresult.m_82425_();
                isConcreteInWater = true;
            }
            if (!this.f_19861_ && !isConcreteInWater) {
                if (!(this.f_19853_.f_46443_ || (this.time <= 100 || blockpos.m_123342_() > this.f_19853_.m_141937_() && blockpos.m_123342_() <= this.f_19853_.m_151558_()) && this.time <= 600)) {
                    if (this.dropItem && this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                        this.m_19998_((ItemLike)block);
                    }
                    this.m_146870_();
                }
            } else {
                this.groundBlock(false);
            }
        }
        this.m_20256_(this.m_20184_().m_82490_(0.98));
    }

    public BlockPos groundBlock(boolean ignoreAir) {
        boolean canSurvive;
        Block block = this.blockState.m_60734_();
        BlockPos blockpos = this.m_20183_();
        BlockState blockstate = this.f_19853_.m_8055_(blockpos);
        boolean isConcrete = this.blockState.m_60734_() instanceof ConcretePowderBlock;
        boolean isConcreteInWater = isConcrete && this.f_19853_.m_6425_(blockpos).m_205070_(FluidTags.f_13131_);
        this.m_20256_(this.m_20184_().m_82542_(0.7, -0.5, 0.7));
        if (blockstate.m_60713_(Blocks.f_50110_)) {
            return null;
        }
        if (this.cancelDrop) {
            this.m_146870_();
            this.callOnBrokenAfterFall(block, blockpos);
            return null;
        }
        boolean canBeReplaced = blockstate.m_60629_((BlockPlaceContext)new DirectionalPlaceContext(this.f_19853_, blockpos, Direction.DOWN, ItemStack.f_41583_, Direction.UP));
        boolean isFreeBelow = FallingBlock.m_53241_((BlockState)this.f_19853_.m_8055_(blockpos.m_7495_())) && (!isConcrete || !isConcreteInWater);
        boolean bl = canSurvive = this.blockState.m_60710_((LevelReader)this.f_19853_, blockpos) && (!isFreeBelow || ignoreAir);
        if (canBeReplaced && canSurvive) {
            if (this.blockState.m_61138_((Property)BlockStateProperties.f_61362_) && this.f_19853_.m_6425_(blockpos).m_76152_() == Fluids.f_76193_) {
                this.blockState = (BlockState)this.blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.TRUE);
            }
            if (this.f_19853_.m_7731_(blockpos, this.blockState, 3)) {
                BlockEntity blockEntity;
                BlockEntity blockentity;
                ((ServerLevel)this.f_19853_).m_7726_().f_8325_.m_140201_((Entity)this, (Packet)new ClientboundBlockUpdatePacket(blockpos, this.f_19853_.m_8055_(blockpos)));
                this.m_146870_();
                if (block instanceof Fallable) {
                    Fallable fallable = (Fallable)block;
                    fallable.m_48792_(this.f_19853_, blockpos, this.blockState, blockstate, new FallingBlockEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.blockState));
                }
                if (this.blockData != null && this.blockState.m_155947_() && (blockentity = this.f_19853_.m_7702_(blockpos)) != null) {
                    try {
                        blockentity.m_142466_(this.blockData);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    blockentity.m_6596_();
                }
                if ((blockEntity = this.f_19853_.m_7702_(blockpos)) instanceof MageBlockTile) {
                    MageBlockTile mbt = (MageBlockTile)blockEntity;
                    mbt.color = this.getParticleColor();
                    mbt.m_6596_();
                }
                return blockpos;
            }
            if (this.dropItem && this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                this.m_146870_();
                this.callOnBrokenAfterFall(block, blockpos);
                this.m_19998_((ItemLike)block);
                return null;
            }
        } else {
            this.m_146870_();
            if (this.dropItem && this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                this.callOnBrokenAfterFall(block, blockpos);
                this.m_19998_((ItemLike)block);
            }
        }
        return null;
    }

    public float getStateDamageBonus() {
        float destroySpeed = 1.0f;
        try {
            destroySpeed = this.blockState.m_60800_((BlockGetter)this.f_19853_, this.m_20183_());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return destroySpeed;
    }

    protected void m_5790_(EntityHitResult pResult) {
        IndirectEntityDamageSource damagesource;
        if (!this.hurtEntities) {
            return;
        }
        super.m_5790_(pResult);
        Entity entity = pResult.m_82443_();
        float f = (float)this.m_20184_().m_82553_();
        int i = Mth.m_14165_((double)Mth.m_14008_((double)(Math.min((double)f, 2.5) * (double)this.baseDamage + (double)this.getStateDamageBonus()), (double)0.0, (double)2.147483647E9));
        this.piercingIgnoreEntityIds.add(entity.m_19879_());
        Entity owner = this.m_37282_();
        if (owner == null) {
            damagesource = new IndirectEntityDamageSource("an_enchantedBlock", (Entity)this, owner);
        } else {
            damagesource = new IndirectEntityDamageSource("an_enchantedBlock", (Entity)this, owner);
            if (owner instanceof LivingEntity) {
                LivingEntity livingOwner = (LivingEntity)owner;
                livingOwner.m_21335_(entity);
            }
        }
        boolean isEnderman = entity.m_6095_() == EntityType.f_20566_;
        int k = entity.m_20094_();
        if (this.m_6060_() && !isEnderman) {
            entity.m_20254_(5);
        }
        if (entity.m_6469_((DamageSource)damagesource, (float)i)) {
            if (isEnderman) {
                return;
            }
            if (entity instanceof LivingEntity) {
                Vec3 vec3;
                LivingEntity livingentity = (LivingEntity)entity;
                if (this.knockback > 0 && (vec3 = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)this.knockback * 0.6)).m_82556_() > 0.0) {
                    livingentity.m_5997_(vec3.f_82479_, 0.1, vec3.f_82481_);
                }
                if (!this.f_19853_.f_46443_ && owner instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingentity, (Entity)owner);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)owner), (Entity)livingentity);
                }
                this.doPostHurtEffects(livingentity);
            }
            this.m_5496_(this.blockState.m_60827_().m_56775_(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
        } else {
            entity.m_7311_(k);
        }
    }

    private void doPostHurtEffects(LivingEntity livingentity) {
    }

    public void m_7976_(CrashReportCategory pCategory) {
        super.m_7976_(pCategory);
        pCategory.m_128159_("Immitating BlockState", (Object)this.blockState.toString());
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    public boolean m_6127_() {
        return true;
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, Block.m_49956_((BlockState)this.getBlockState()));
    }

    public void m_141965_(ClientboundAddEntityPacket pPacket) {
        super.m_141965_(pPacket);
        this.blockState = Block.m_49803_((int)pPacket.m_131509_());
        this.f_19850_ = true;
        double d0 = pPacket.m_131500_();
        double d1 = pPacket.m_131501_();
        double d2 = pPacket.m_131502_();
        this.m_6034_(d0, d1, d2);
        this.setStartPos(this.m_20183_());
    }

    public void callOnBrokenAfterFall(Block p_149651_, BlockPos p_149652_) {
        if (p_149651_ instanceof Fallable) {
            ((Fallable)p_149651_).m_142525_(this.f_19853_, p_149652_, new FallingBlockEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.blockState));
        }
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        DamageSource damagesource;
        Predicate predicate;
        if (!this.hurtEntities) {
            return false;
        }
        int i = Mth.m_14167_((float)(pFallDistance - 1.0f));
        if (i < 0) {
            return false;
        }
        Block block = this.blockState.m_60734_();
        if (block instanceof Fallable) {
            Fallable fallable = (Fallable)block;
            predicate = fallable.m_142398_();
            damagesource = fallable.m_142088_();
        } else {
            predicate = EntitySelector.f_20408_;
            damagesource = DamageSource.f_19322_;
        }
        float f = Math.min(Mth.m_14143_((float)((float)i * this.fallDamagePerDistance)), this.fallDamageMax);
        this.f_19853_.m_6249_((Entity)this, this.m_20191_(), predicate).forEach(p_149649_ -> p_149649_.m_6469_(damagesource, f));
        boolean flag = this.blockState.m_204336_(BlockTags.f_13033_);
        if (flag && f > 0.0f && this.f_19796_.m_188501_() < 0.05f + (float)i * 0.05f) {
            BlockState blockstate = AnvilBlock.m_48824_((BlockState)this.blockState);
            if (blockstate == null) {
                this.cancelDrop = true;
            } else {
                this.blockState = blockstate;
            }
        }
        return false;
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128365_("BlockState", (Tag)NbtUtils.m_129202_((BlockState)this.blockState));
        pCompound.m_128405_("Time", this.time);
        pCompound.m_128379_("DropItem", this.dropItem);
        pCompound.m_128379_("HurtEntities", this.hurtEntities);
        pCompound.m_128350_("FallHurtAmount", this.fallDamagePerDistance);
        pCompound.m_128405_("FallHurtMax", this.fallDamageMax);
        if (this.blockData != null) {
            pCompound.m_128365_("TileEntityData", (Tag)this.blockData);
        }
        pCompound.m_128379_("shouldColor", ((Boolean)this.f_19804_.m_135370_(SHOULD_COLOR)).booleanValue());
    }

    @Override
    public void m_20258_(CompoundTag compound) {
        super.m_20258_(compound);
        this.f_19804_.m_135381_(SHOULD_COLOR, (Object)compound.m_128471_("shouldColor"));
    }

    protected void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.blockState = NbtUtils.m_129241_((CompoundTag)pCompound.m_128469_("BlockState"));
        this.time = pCompound.m_128451_("Time");
        if (pCompound.m_128425_("HurtEntities", 99)) {
            this.hurtEntities = pCompound.m_128471_("HurtEntities");
            this.fallDamagePerDistance = pCompound.m_128457_("FallHurtAmount");
            this.fallDamageMax = pCompound.m_128451_("FallHurtMax");
        } else if (this.blockState.m_204336_(BlockTags.f_13033_)) {
            this.hurtEntities = true;
        }
        if (pCompound.m_128425_("DropItem", 99)) {
            this.dropItem = pCompound.m_128471_("DropItem");
        }
        if (pCompound.m_128425_("TileEntityData", 10)) {
            this.blockData = pCompound.m_128469_("TileEntityData");
        }
        if (this.blockState.m_60795_()) {
            this.blockState = Blocks.f_49992_.m_49966_();
        }
    }

    public void setHurtsEntities(float p_149657_, int p_149658_) {
        this.hurtEntities = true;
        this.fallDamagePerDistance = p_149657_;
        this.fallDamageMax = p_149658_;
    }

    public boolean m_6097_() {
        return false;
    }

    public void setStartPos(BlockPos pOrigin) {
        this.f_19804_.m_135381_(DATA_START_POS, (Object)pOrigin);
    }

    public BlockPos getStartPos() {
        return (BlockPos)this.f_19804_.m_135370_(DATA_START_POS);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_START_POS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(SHOULD_COLOR, (Object)false);
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    @Override
    public void registerControllers(AnimationData data) {
    }

    @Override
    public AnimationFactory getFactory() {
        return GeckoLibUtil.createFactory(this);
    }
}

