/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.common.items.FamiliarScript;
import com.hollingsworth.arsnouveau.common.items.Glyph;
import com.hollingsworth.arsnouveau.common.items.PerkItem;
import com.hollingsworth.arsnouveau.common.items.RitualTablet;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraftforge.common.data.LanguageProvider;

public class LangDatagen
extends LanguageProvider {
    public LangDatagen(DataGenerator gen, String modid, String locale) {
        super(gen, modid, locale);
    }

    protected void addTranslations() {
        ArsNouveauAPI arsNouveauAPI = ArsNouveauAPI.getInstance();
        for (Supplier<Glyph> supplier : arsNouveauAPI.getGlyphItemMap().values()) {
            Glyph i = supplier.get();
            if (!supplier.get().spellPart.getRegistryName().m_135827_().equals("ars_nouveau")) continue;
            this.add("ars_nouveau.glyph_desc." + i.spellPart.getRegistryName().m_135815_(), i.spellPart.getBookDescription());
            this.add("ars_nouveau.glyph_name." + i.spellPart.getRegistryName().m_135815_(), i.spellPart.getName());
        }
        for (FamiliarScript familiarScript : arsNouveauAPI.getFamiliarScriptMap().values()) {
            if (!familiarScript.familiar.getRegistryName().m_135827_().equals("ars_nouveau")) continue;
            this.add("ars_nouveau.familiar_desc." + familiarScript.familiar.getRegistryName().m_135815_(), familiarScript.familiar.getBookDescription());
            this.add("ars_nouveau.familiar_name." + familiarScript.familiar.getRegistryName().m_135815_(), familiarScript.familiar.getBookName());
            this.add("item.ars_nouveau." + familiarScript.familiar.getRegistryName().m_135815_(), familiarScript.familiar.getBookName());
        }
        for (RitualTablet ritualTablet : arsNouveauAPI.getRitualItemMap().values()) {
            if (!ritualTablet.ritual.getRegistryName().m_135827_().equals("ars_nouveau")) continue;
            this.add("ars_nouveau.ritual_desc." + ritualTablet.ritual.getRegistryName().m_135815_(), ritualTablet.ritual.getLangDescription());
            this.add("item.ars_nouveau." + ritualTablet.ritual.getRegistryName().m_135815_(), ritualTablet.ritual.getLangName());
        }
        for (PerkItem perkItem : arsNouveauAPI.getPerkItemMap().values()) {
            if (!perkItem.perk.getRegistryName().m_135827_().equals("ars_nouveau")) continue;
            this.add("ars_nouveau.perk_desc." + perkItem.perk.getRegistryName().m_135815_(), perkItem.perk.getLangDescription());
            this.add("item.ars_nouveau." + perkItem.perk.getRegistryName().m_135815_(), perkItem.perk.getLangName());
        }
    }
}

