/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.hollingsworth.arsnouveau.api.loot.DungeonLootTables;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.data.GlobalLootModifierProvider;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.common.loot.LootTableIdCondition;

public class DungeonLootGenerator
extends GlobalLootModifierProvider {
    public DungeonLootGenerator(DataGenerator gen, String modid) {
        super(gen, modid);
    }

    protected void start() {
    }

    public LootItemCondition getList(String[] chests) {
        Object condition = null;
        for (String s : chests) {
            condition = condition == null ? LootTableIdCondition.builder((ResourceLocation)new ResourceLocation(s)) : condition.m_7818_((LootItemCondition.Builder)LootTableIdCondition.builder((ResourceLocation)new ResourceLocation(s)));
        }
        return condition.m_6409_();
    }

    public static class DungeonLootEnhancerModifier
    extends LootModifier {
        public double commonChance;
        public double uncommonChance;
        public double rareChance;
        public int commonRolls;
        public int uncommonRolls;
        public int rareRolls;
        public static final Supplier<Codec<DungeonLootEnhancerModifier>> CODEC = () -> RecordCodecBuilder.create(instance -> instance.group((App)LOOT_CONDITIONS_CODEC.fieldOf("conditions").forGetter(lm -> lm.conditions), (App)Codec.DOUBLE.fieldOf("common_chance").forGetter(d -> d.commonChance), (App)Codec.DOUBLE.fieldOf("uncommon_chance").forGetter(d -> d.uncommonChance), (App)Codec.DOUBLE.fieldOf("rare_chance").forGetter(d -> d.rareChance), (App)Codec.INT.fieldOf("common_rolls").forGetter(d -> d.commonRolls), (App)Codec.INT.fieldOf("uncommon_rolls").forGetter(d -> d.uncommonRolls), (App)Codec.INT.fieldOf("rare_rolls").forGetter(d -> d.rareRolls)).apply((Applicative)instance, DungeonLootEnhancerModifier::new));

        public DungeonLootEnhancerModifier(LootItemCondition[] conditionsIn, double commonChance, double uncommonChance, double rareChance, int commonRolls, int uncommonRolls, int rareRolls) {
            super(conditionsIn);
            this.commonChance = commonChance;
            this.uncommonChance = uncommonChance;
            this.rareChance = rareChance;
            this.commonRolls = commonRolls;
            this.uncommonRolls = uncommonRolls;
            this.rareRolls = rareRolls;
        }

        public DungeonLootEnhancerModifier(LootItemCondition[] conditionsIn) {
            super(conditionsIn);
            this.commonChance = 0.3;
            this.uncommonChance = 0.2;
            this.rareChance = 0.1;
            this.commonRolls = 3;
            this.uncommonRolls = 2;
            this.rareRolls = 1;
        }

        protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            generatedLoot.addAll(DungeonLootTables.getRandomRoll(this));
            return generatedLoot;
        }

        public Codec<? extends IGlobalLootModifier> codec() {
            return CODEC.get();
        }
    }
}

