/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.camera;

import com.hollingsworth.arsnouveau.common.block.ScryerCrystal;
import com.hollingsworth.arsnouveau.common.entity.ScryerCamera;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketDismountCamera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ars_nouveau", value={Dist.CLIENT})
public class CameraController {
    public static CameraType previousCameraType;
    public static boolean resetOverlaysAfterDismount;
    private static ClientChunkCache.Storage cameraStorage;
    private static boolean wasUpPressed;
    private static boolean wasDownPressed;
    private static boolean wasLeftPressed;
    private static boolean wasRightPressed;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Entity cameraEntity = Minecraft.m_91087_().f_91075_;
        if (cameraEntity instanceof ScryerCamera) {
            ScryerCamera cam = (ScryerCamera)cameraEntity;
            Options options = Minecraft.m_91087_().f_91066_;
            if (event.phase == TickEvent.Phase.START) {
                wasUpPressed = options.f_92085_.m_90857_();
                if (wasUpPressed) {
                    options.f_92085_.m_7249_(false);
                }
                if (wasDownPressed = options.f_92087_.m_90857_()) {
                    options.f_92087_.m_7249_(false);
                }
                if (wasLeftPressed = options.f_92086_.m_90857_()) {
                    options.f_92086_.m_7249_(false);
                }
                if (wasRightPressed = options.f_92088_.m_90857_()) {
                    options.f_92088_.m_7249_(false);
                }
                if (options.f_92090_.m_90857_()) {
                    CameraController.dismount();
                    options.f_92090_.m_7249_(false);
                }
            } else if (event.phase == TickEvent.Phase.END) {
                if (wasUpPressed) {
                    CameraController.moveViewUp(cam);
                    options.f_92085_.m_7249_(true);
                }
                if (wasDownPressed) {
                    CameraController.moveViewDown(cam);
                    options.f_92087_.m_7249_(true);
                }
                if (wasLeftPressed) {
                    CameraController.moveViewHorizontally(cam, cam.m_146908_(), cam.m_146908_() - (float)cam.cameraSpeed * cam.zoomAmount);
                    options.f_92086_.m_7249_(true);
                }
                if (wasRightPressed) {
                    CameraController.moveViewHorizontally(cam, cam.m_146908_(), cam.m_146908_() + (float)cam.cameraSpeed * cam.zoomAmount);
                    options.f_92088_.m_7249_(true);
                }
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                double yRotChange = player.m_146908_() - player.f_108598_;
                double xRotChange = player.m_146909_() - player.f_108599_;
                if (yRotChange != 0.0 || xRotChange != 0.0) {
                    player.f_108617_.m_104955_((Packet)new ServerboundMovePlayerPacket.Rot(player.m_146908_(), player.m_146909_(), player.m_20096_()));
                }
            }
        }
    }

    private static void dismount() {
        Networking.INSTANCE.sendToServer((Object)new PacketDismountCamera());
    }

    public static void moveViewUp(ScryerCamera cam) {
        float next = cam.m_146909_() - (float)cam.cameraSpeed * cam.zoomAmount;
        if (cam.isCameraDown()) {
            if (next > 40.0f) {
                cam.setRotation(cam.m_146908_(), next);
            }
        } else if (next > -25.0f) {
            cam.setRotation(cam.m_146908_(), next);
        }
    }

    public static void moveViewDown(ScryerCamera cam) {
        float next = cam.m_146909_() + (float)cam.cameraSpeed * cam.zoomAmount;
        if (cam.isCameraDown()) {
            if (next < 90.0f) {
                cam.setRotation(cam.m_146908_(), next);
            }
        } else if (next < 60.0f) {
            cam.setRotation(cam.m_146908_(), next);
        }
    }

    public static void moveViewHorizontally(ScryerCamera cam, float yRot, float next) {
        BlockState state = cam.f_19853_.m_8055_(cam.m_20183_());
        if (state.m_61138_((Property)ScryerCrystal.FACING)) {
            boolean shouldSetRotation;
            float checkNext = next;
            if (checkNext < 0.0f) {
                checkNext += 360.0f;
            }
            switch ((Direction)state.m_61143_((Property)ScryerCrystal.FACING)) {
                case NORTH: {
                    boolean bl;
                    if (checkNext > 90.0f && checkNext < 270.0f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case SOUTH: {
                    boolean bl;
                    if (checkNext > 270.0f || checkNext < 90.0f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case EAST: {
                    boolean bl;
                    if (checkNext > 180.0f && checkNext < 360.0f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case WEST: {
                    boolean bl;
                    if (checkNext > 0.0f && checkNext < 180.0f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case DOWN: {
                    boolean bl = true;
                    break;
                }
                default: {
                    boolean bl = shouldSetRotation = false;
                }
            }
            if (shouldSetRotation) {
                cam.m_146922_(next);
            }
        }
    }

    public static void zoomIn(ScryerCamera cam) {
        cam.zooming = true;
        cam.zoomAmount = Math.max(cam.zoomAmount - 0.1f, 0.1f);
    }

    public static void zoomOut(ScryerCamera cam) {
        cam.zooming = true;
        cam.zoomAmount = Math.min(cam.zoomAmount + 0.1f, 1.4f);
    }

    public static ClientChunkCache.Storage getCameraStorage() {
        return cameraStorage;
    }

    public static void setCameraStorage(ClientChunkCache.Storage cameraStorage) {
        if (cameraStorage != null) {
            CameraController.cameraStorage = cameraStorage;
        }
    }

    public static void setRenderPosition(Entity entity) {
        if (entity instanceof ScryerCamera) {
            SectionPos cameraPos = SectionPos.m_235861_((EntityAccess)entity);
            CameraController.cameraStorage.f_104469_ = cameraPos.m_123170_();
            CameraController.cameraStorage.f_104470_ = cameraPos.m_123222_();
        }
    }

    static {
        resetOverlaysAfterDismount = false;
    }
}

