/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.block.TickableModBlock;
import com.hollingsworth.arsnouveau.common.block.tile.RitualBrazierTile;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;

public class RitualBrazierBlock
extends TickableModBlock {
    public static final Property<Boolean> LIT = BooleanProperty.m_61465_((String)"lit");

    public RitualBrazierBlock() {
        super(RitualBrazierBlock.defaultProperties().m_60955_().m_60953_(b -> (Boolean)b.m_61143_(LIT) != false ? 15 : 0));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        RitualBrazierTile tile;
        block5: {
            block4: {
                BlockEntity blockEntity = worldIn.m_7702_(pos);
                if (!(blockEntity instanceof RitualBrazierTile)) break block4;
                tile = (RitualBrazierTile)blockEntity;
                if (handIn == InteractionHand.MAIN_HAND && player.m_21205_().m_41619_()) break block5;
            }
            return super.m_6227_(state, worldIn, pos, player, handIn, hit);
        }
        if (tile.ritual != null && !tile.isRitualDone()) {
            tile.startRitual();
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    public PushReaction m_5537_(BlockState p_149656_1_) {
        return PushReaction.BLOCK;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity;
        super.m_6861_(state, world, pos, blockIn, fromPos, isMoving);
        if (!world.m_5776_() && (blockEntity = world.m_7702_(pos)) instanceof RitualBrazierTile) {
            RitualBrazierTile tile = (RitualBrazierTile)blockEntity;
            tile.isOff = world.m_46753_(pos);
            if (world.m_46753_(pos) && tile.ritual != null && tile.canRitualStart()) {
                tile.startRitual();
            }
            BlockUtil.safelyUpdateState(world, pos);
        }
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        super.m_5707_(worldIn, pos, state, player);
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof RitualBrazierTile) {
            RitualBrazierTile tile = (RitualBrazierTile)blockEntity;
            if (tile.ritual != null && !tile.ritual.isRunning() && !tile.ritual.isDone()) {
                worldIn.m_7967_((Entity)new ItemEntity(worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)ArsNouveauAPI.getInstance().getRitualItemMap().get(tile.ritual.getRegistryName()))));
            }
        }
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        if (entity != null) {
            world.m_7731_(pos, (BlockState)state.m_61124_(LIT, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new RitualBrazierTile(pos, state);
    }
}

