/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.write.biome;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;

public class BiomeBlendCalculator
implements BlockAndTintGetter {
    private Level original;

    public void setWorld(Level original) {
        this.original = original;
    }

    public BlockEntity m_7702_(BlockPos blockPos) {
        return this.original.m_7702_(blockPos);
    }

    public BlockState m_8055_(BlockPos blockPos) {
        return this.original.m_8055_(blockPos);
    }

    public FluidState m_6425_(BlockPos blockPos) {
        return this.original.m_6425_(blockPos);
    }

    public float m_7717_(Direction direction, boolean bl) {
        return this.original.m_7717_(direction, bl);
    }

    public LevelLightEngine m_5518_() {
        return this.original.m_5518_();
    }

    public int m_141928_() {
        return this.original.m_141928_();
    }

    public int m_141937_() {
        return this.original.m_141937_();
    }

    public int m_6171_(BlockPos blockPos, ColorResolver colorResolver) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int x = blockPos.m_123341_();
        int y = blockPos.m_123342_();
        int z = blockPos.m_123343_();
        int redAccumulator = 0;
        int greenAccumulator = 0;
        int blueAccumulator = 0;
        Level original = this.original;
        int count = 0;
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                Biome biome;
                if (i != 0 && j != 0) continue;
                mutableBlockPos.m_122178_(x + i, y, z + j);
                Holder biomeHolder = original.m_204166_((BlockPos)mutableBlockPos);
                Biome biome2 = biome = biomeHolder == null ? null : (Biome)biomeHolder.m_203334_();
                if (biome == null) continue;
                int colorSample = colorResolver.m_130045_(biome, (double)mutableBlockPos.m_123341_(), (double)mutableBlockPos.m_123343_());
                redAccumulator += colorSample & 0xFF0000;
                greenAccumulator += colorSample & 0xFF00;
                blueAccumulator += colorSample & 0xFF;
                ++count;
            }
        }
        int red = redAccumulator / count;
        int green = greenAccumulator / count;
        int blue = blueAccumulator / count;
        return 0xFF000000 | red & 0xFF0000 | green & 0xFF00 | blue;
    }
}

