/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.renderer.texture.OverlayTexture;
import org.lwjgl.opengl.GL11;
import xaero.common.MinimapLogs;
import xaero.common.minimap.render.radar.ModelPartRenderDetectionInfo;
import xaero.common.minimap.render.radar.ModelRenderDetectionElement;
import xaero.common.misc.Misc;

public class EntityIconModelPartsRenderer {
    public Method ageableModelHeadPartsMethod = Misc.getMethodReflection(AgeableListModel.class, "m_5607_", "headParts", new Class[0]);
    public Method ageableModelBodyPartsMethod = Misc.getMethodReflection(AgeableListModel.class, "m_5608_", "bodyParts", new Class[0]);
    public Method segmentedModelPartsMethod = Misc.getMethodReflection(ListModel.class, "m_6195_", "parts", new Class[0]);
    private Field cubeListField = Misc.getFieldReflection(ModelPart.class, "f_104212_", "cubes");
    private Field childModelsField = Misc.getFieldReflection(ModelPart.class, "f_104213_", "children");

    private List<ModelPart.Cube> getCubeList(ModelPart modelRenderer) {
        return (List)Misc.getReflectFieldValue(modelRenderer, this.cubeListField);
    }

    public Map<String, ModelPart> getChildModels(ModelPart modelRenderer) {
        return (Map)Misc.getReflectFieldValue(modelRenderer, this.childModelsField);
    }

    public boolean hasDirectCubes(ModelPart mr) {
        List<ModelPart.Cube> mrCubeList = this.getCubeList(mr);
        return mrCubeList != null && !mrCubeList.isEmpty();
    }

    public boolean hasCubes(ModelPart mr) {
        if (this.hasDirectCubes(mr)) {
            return true;
        }
        Map<String, ModelPart> mrChildren = this.getChildModels(mr);
        for (ModelPart child : mrChildren.values()) {
            if (!this.hasCubes(child)) continue;
            return true;
        }
        return false;
    }

    public void renderPart(PoseStack matrixStack, VertexConsumer vertexBuilder, ModelPart mr, ArrayList<ModelPart> renderedModels, ModelPart mainModelPart, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        if (mr == null) {
            return;
        }
        if (renderedModels.contains(mr)) {
            return;
        }
        ModelPartRenderDetectionInfo renderInfo = mrde.getModelPartRenderInfo(mr);
        if (renderInfo == null) {
            return;
        }
        if (!this.hasCubes(mr)) {
            return;
        }
        boolean showModelBU = mr.f_104207_;
        float centerPointX = mainModelPart.f_104200_;
        float centerPointY = mainModelPart.f_104201_;
        float centerPointZ = mainModelPart.f_104202_;
        List<ModelPart.Cube> mainCubeList = this.getCubeList(mainModelPart);
        if (mainCubeList != null && !mainCubeList.isEmpty()) {
            float biggestSize = 0.0f;
            ModelPart.Cube biggestCuboid = null;
            for (ModelPart.Cube cuboid : mainCubeList) {
                float size = Math.abs((cuboid.f_104338_ - cuboid.f_104335_) * (cuboid.f_104339_ - cuboid.f_104336_) * (cuboid.f_104340_ - cuboid.f_104337_));
                if (!(size >= biggestSize)) continue;
                biggestCuboid = cuboid;
                biggestSize = size;
            }
            centerPointY += (biggestCuboid.f_104339_ + biggestCuboid.f_104336_) / 2.0f;
            centerPointZ += (biggestCuboid.f_104340_ + biggestCuboid.f_104337_) / 2.0f;
        }
        float xRotBU = 0.0f;
        float yRotBU = 0.0f;
        float zRotBU = 0.0f;
        if (zeroRotation) {
            xRotBU = mr.f_104203_;
            yRotBU = mr.f_104204_;
            zRotBU = mr.f_104205_;
            PartPose initPose = mr.m_233566_();
            mr.m_171327_(initPose.f_171408_, initPose.f_171409_, initPose.f_171410_);
        }
        mr.f_104207_ = true;
        try {
            float xBU = mr.f_104200_;
            float yBU = mr.f_104201_;
            float zBU = mr.f_104202_;
            mr.m_104227_(mr.f_104200_ - centerPointX, mr.f_104201_ - centerPointY, mr.f_104202_ - centerPointZ);
            mr.m_104306_(matrixStack, vertexBuilder, 0xF000F0, OverlayTexture.f_118083_, renderInfo.red, renderInfo.green, renderInfo.blue, renderInfo.alpha);
            renderedModels.add(mr);
            mr.m_104227_(xBU, yBU, zBU);
        }
        catch (Throwable t) {
            MinimapLogs.LOGGER.info("Exception when rendering entity part. " + mr);
        }
        while (GL11.glGetError() != 0) {
        }
        if (zeroRotation) {
            mr.m_171327_(xRotBU, yRotBU, zRotBU);
        }
        mr.f_104207_ = showModelBU;
    }

    public ModelPart renderDeclaredMethod(PoseStack matrixStack, VertexConsumer vertexBuilder, Method m, EntityModel entityModel, ArrayList<ModelPart> renderedModels, ModelPart mainPart, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        Iterable<ModelPart> renderers = this.handleDeclaredMethod(m, entityModel);
        return this.renderPartsIterable(renderers, matrixStack, vertexBuilder, renderedModels, mainPart, zeroRotation, mrde);
    }

    public Iterable<ModelPart> handleDeclaredMethod(Method m, EntityModel entityModel) {
        if (m != null) {
            return (Iterable)Misc.getReflectMethodValue(entityModel, m, new Object[0]);
        }
        return null;
    }

    public ModelPart renderPartsIterable(Iterable<ModelPart> parts, PoseStack matrixStack, VertexConsumer vertexBuilder, ArrayList<ModelPart> renderedModels, ModelPart mainPart, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        if (parts == null) {
            return mainPart;
        }
        Iterator<ModelPart> partsIterator = parts.iterator();
        if (partsIterator.hasNext()) {
            if (mainPart == null) {
                mainPart = partsIterator.next();
                this.renderPart(matrixStack, vertexBuilder, mainPart, renderedModels, mainPart, zeroRotation, mrde);
            }
            while (partsIterator.hasNext()) {
                this.renderPart(matrixStack, vertexBuilder, partsIterator.next(), renderedModels, mainPart, zeroRotation, mrde);
            }
        }
        return mainPart;
    }
}

