/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.graphics.CustomVertexConsumers;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.MinimapInterface;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.radar.MinimapRadar;
import xaero.common.minimap.radar.category.EntityRadarCategory;
import xaero.common.minimap.radar.category.setting.EntityRadarCategorySettings;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.render.MinimapSafeModeRenderer;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.minimap.waypoints.render.CompassRenderer;
import xaero.common.minimap.waypoints.render.WaypointsGuiRenderer;
import xaero.common.misc.Misc;
import xaero.common.misc.OptimizedMath;
import xaero.common.settings.ModSettings;

public abstract class MinimapRenderer {
    public static final int black = -16777216;
    public static final int slime = -2142047936;
    protected IXaeroMinimap modMain;
    protected Minecraft mc;
    protected MinimapInterface minimapInterface;
    protected MinimapRendererHelper helper;
    protected WaypointsGuiRenderer waypointsGuiRenderer;
    private int lastMinimapSize;
    private ArrayList<Component> underText;
    protected double zoom = 1.0;
    private BlockPos.MutableBlockPos mutableBlockPos;
    protected final CompassRenderer compassRenderer;

    public MinimapRenderer(IXaeroMinimap modMain, Minecraft mc, WaypointsGuiRenderer waypointsGuiRenderer, MinimapInterface minimapInterface, CompassRenderer compassRenderer) {
        this.modMain = modMain;
        this.mc = mc;
        this.waypointsGuiRenderer = waypointsGuiRenderer;
        this.minimapInterface = minimapInterface;
        this.underText = new ArrayList();
        this.helper = new MinimapRendererHelper();
        this.mutableBlockPos = new BlockPos.MutableBlockPos();
        this.compassRenderer = compassRenderer;
    }

    public double getRenderAngle(boolean lockedNorth) {
        if (lockedNorth) {
            return 90.0;
        }
        return this.getActualAngle();
    }

    private double getActualAngle() {
        double rotation = this.mc.f_91063_.m_109153_().m_90590_();
        return -90.0 - rotation;
    }

    protected abstract void renderChunks(XaeroMinimapSession var1, PoseStack var2, MinimapProcessor var3, int var4, int var5, float var6, float var7, int var8, boolean var9, boolean var10, int var11, double var12, double var14, boolean var16, boolean var17, ModSettings var18, CustomVertexConsumers var19);

    public void renderMinimap(XaeroMinimapSession minimapSession, PoseStack matrixStack, MinimapProcessor minimap, int x, int y, int width, int height, double scale, int size, float partial, CustomVertexConsumers cvc) {
        WaypointsManager waypointsManager;
        ResourceLocation dimensionId;
        boolean crosshairDisplayed;
        int specW;
        int frameType;
        boolean renderFrame;
        ModSettings settings = this.modMain.getSettings();
        if (settings.getMinimapSize() != this.lastMinimapSize) {
            this.lastMinimapSize = settings.getMinimapSize();
            minimap.setToResetImage(true);
        }
        if (this.modMain.getSupportMods().pac()) {
            this.modMain.getSupportMods().xaeroPac.resetRenderedOnRadarFlags();
        }
        this.mc.f_91065_.m_93250_(0);
        minimap.getEntityRadar().setLastRenderViewEntity(this.mc.m_91288_());
        ArrayList<Component> underText = this.underText;
        int mapSize = minimapSession.getMinimapProcessor().getMinimapSize();
        int bufferSize = minimapSession.getMinimapProcessor().getMinimapBufferSize(mapSize);
        if (this.minimapInterface.usingFBO()) {
            bufferSize = minimap.getFBOBufferSize();
        }
        float minimapScale = settings.getMinimapScale();
        float mapScale = (float)(scale / (double)minimapScale);
        minimap.updateZoom();
        this.zoom = minimap.getMinimapZoom();
        Lighting.m_84930_();
        RenderSystem.m_69465_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69854_((int)3317, (int)4);
        RenderSystem.m_69854_((int)3316, (int)0);
        RenderSystem.m_69854_((int)3315, (int)0);
        RenderSystem.m_69854_((int)3314, (int)0);
        float sizeFix = (float)bufferSize / 512.0f;
        int shape = settings.minimapShape;
        boolean lockedNorth = settings.getLockNorth(mapSize / 2, shape);
        double angle = Math.toRadians(this.getRenderAngle(lockedNorth));
        double ps = Math.sin(Math.PI - angle);
        double pc = Math.cos(Math.PI - angle);
        boolean useWorldMap = this.modMain.getSupportMods().shouldUseWorldMapChunks() && minimap.getMinimapWriter().getLoadedCaving() == Integer.MAX_VALUE && minimap.getMinimapWriter().loadedLightOverlayType <= 0;
        int lightLevel = (int)((1.0f - Math.min(1.0f, this.getSunBrightness())) * (float)(minimap.getMinimapWriter().getLoadedLevels() - 1));
        boolean cave = !useWorldMap && minimap.getMinimapWriter().getLoadedCaving() != Integer.MAX_VALUE;
        boolean circleShape = shape == 1;
        matrixStack.m_85836_();
        this.renderChunks(minimapSession, matrixStack, minimap, mapSize, bufferSize, sizeFix, partial, lightLevel, useWorldMap, lockedNorth, shape, ps, pc, cave, circleShape, settings, cvc);
        if (this.minimapInterface.usingFBO()) {
            sizeFix = 1.0f;
        }
        RenderSystem.m_69493_();
        RenderSystem.m_69478_();
        RenderSystem.m_69405_((int)770, (int)771);
        matrixStack.m_85841_(1.0f / mapScale, 1.0f / mapScale, 1.0f);
        int scaledX = (int)((float)x * mapScale);
        int scaledY = (int)((float)y * mapScale);
        int minimapFrameSize = (int)((float)(mapSize / 2) / sizeFix);
        int circleSides = Math.max(32, (int)Math.ceil(Math.PI * (double)(minimapFrameSize + 8) / 8.0 / 4.0) * 4);
        double circleSeamAngle = -0.7853981633974483;
        int circleSeamWidth = 32;
        int circleFrameThickness = 4;
        double circleStartAngle = 0.0;
        if (!circleShape) {
            this.getHelper().drawMyTexturedModalRect(matrixStack, (int)((float)(scaledX + 9) / sizeFix), (int)((float)(scaledY + 9) / sizeFix), 0, 256 - minimapFrameSize, minimapFrameSize, minimapFrameSize, minimapFrameSize, 256.0f);
        } else {
            float outerRadius = mapSize / 4 + circleFrameThickness;
            circleStartAngle = circleSeamAngle - (double)((float)(circleSeamWidth / 2) / outerRadius);
            this.getHelper().drawTexturedElipseInsideRectangle(matrixStack, circleStartAngle, circleSides, (int)((float)(scaledX + 9) / sizeFix), (int)((float)(scaledY + 9) / sizeFix), 0, 256 - minimapFrameSize, minimapFrameSize, 256.0f);
        }
        if (!this.minimapInterface.usingFBO()) {
            matrixStack.m_85841_(1.0f / sizeFix, 1.0f / sizeFix, 1.0f);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        boolean bl = renderFrame = (frameType = settings.minimapFrame) < ModSettings.FRAME_OPTIONS.length - 1;
        if (frameType > 0) {
            int frameColor = ModSettings.COLORS[settings.minimapFrameColor];
            RenderSystem.m_157429_((float)((float)(frameColor >> 16 & 0xFF) / 255.0f), (float)((float)(frameColor >> 8 & 0xFF) / 255.0f), (float)((float)(frameColor & 0xFF) / 255.0f), (float)1.0f);
        }
        MinimapRendererHelper helper = this.getHelper();
        if (renderFrame) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)InterfaceRenderer.minimapFrameTextures);
        }
        if (renderFrame && !circleShape) {
            int rightCornerStartX = scaledX + 9 + mapSize / 2 + 4 - 16;
            int bottomCornerStartY = scaledY + 9 + mapSize / 2 + 4 - 16;
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder vertexBuffer = tessellator.m_85915_();
            vertexBuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            Matrix4f matrix = matrixStack.m_85850_().m_85861_();
            int cornerTextureX = frameType == 0 ? 192 : (frameType == 1 ? 208 : 224);
            helper.addTexturedRectToExistingBuffer(matrix, (VertexConsumer)vertexBuffer, scaledX + 9 - 4, scaledY + 9 - 4, cornerTextureX, 97, 16, 16);
            helper.addTexturedRectToExistingBuffer(matrix, (VertexConsumer)vertexBuffer, rightCornerStartX, scaledY + 9 - 4, cornerTextureX, 113, 16, 16);
            helper.addTexturedRectToExistingBuffer(matrix, (VertexConsumer)vertexBuffer, scaledX + 9 - 4, bottomCornerStartY, cornerTextureX, 129, 16, 16);
            helper.addTexturedRectToExistingBuffer(matrix, (VertexConsumer)vertexBuffer, rightCornerStartX, bottomCornerStartY, cornerTextureX, 145, 16, 16);
            int horLineStartX = scaledX + 9 - 4 + 16;
            int horLineWidth = rightCornerStartX - horLineStartX;
            int horPieceTextureY = frameType == 0 ? 0 : (frameType == 1 ? 32 : 64);
            int horPieceWidth = 226;
            int horLineLength = (int)Math.ceil((double)horLineWidth / (double)horPieceWidth);
            for (int i = 0; i < horLineLength; ++i) {
                int pieceX = scaledX + 9 - 4 + 16 + i * horPieceWidth;
                int pieceW = horPieceWidth;
                if (i == horLineLength - 1 && pieceX + pieceW > rightCornerStartX) {
                    pieceW = rightCornerStartX - pieceX;
                }
                helper.addTexturedRectToExistingBuffer(matrix, (VertexConsumer)vertexBuffer, pieceX, scaledY + 9 - 4, 0, horPieceTextureY, pieceW, 16);
                helper.addTexturedRectToExistingBuffer(matrix, (VertexConsumer)vertexBuffer, pieceX, scaledY + 9 + mapSize / 2 - 12, 0, horPieceTextureY + 16, pieceW, 16);
            }
            int verLineStartY = scaledY + 9 - 4 + 16;
            int verLineHeight = bottomCornerStartY - verLineStartY;
            int verPieceTextureX = frameType == 0 ? 0 : (frameType == 1 ? 64 : 128);
            int verPieceHeight = 113;
            int vertLineLength = (int)Math.ceil((double)verLineHeight / (double)verPieceHeight);
            for (int i = 0; i < vertLineLength; ++i) {
                int pieceY = scaledY + 9 - 4 + 16 + i * verPieceHeight;
                int pieceU = verPieceTextureX + 32 * (i & 1);
                int pieceH = verPieceHeight;
                if (i == vertLineLength - 1 && pieceY + pieceH > bottomCornerStartY) {
                    pieceH = bottomCornerStartY - pieceY;
                }
                helper.addTexturedRectToExistingBuffer(matrix, (VertexConsumer)vertexBuffer, scaledX + 9 - 4, pieceY, pieceU, 97, 16, pieceH);
                helper.addTexturedRectToExistingBuffer(matrix, (VertexConsumer)vertexBuffer, scaledX + 9 + mapSize / 2 - 12, pieceY, pieceU + 16, 97, 16, pieceH);
            }
            tessellator.m_85914_();
        } else if (renderFrame) {
            int frameTextureY = frameType == 0 ? 210 : (frameType == 1 ? 214 : 218);
            double shadeStartAngle = 0.7853981633974483 - circleStartAngle;
            int shadeStartIndex = (int)(shadeStartAngle / 2.0 / Math.PI * (double)circleSides);
            int circleLeftX = scaledX + 9;
            int circleTopY = scaledY + 9;
            int innerCircleDiameter = mapSize / 2;
            helper.drawTexturedElipseInsideRectangleFrame(matrixStack, false, false, circleStartAngle, 0, shadeStartIndex, circleSides, circleFrameThickness, circleLeftX, circleTopY, 0, frameTextureY, innerCircleDiameter, 73.0f, circleFrameThickness, circleSeamWidth, 256.0f);
            helper.drawTexturedElipseInsideRectangleFrame(matrixStack, true, false, circleStartAngle, shadeStartIndex, shadeStartIndex + circleSides / 4, circleSides, circleFrameThickness, circleLeftX, circleTopY, 138, frameTextureY, innerCircleDiameter, 68.0f, circleFrameThickness, 20, 256.0f);
            helper.drawTexturedElipseInsideRectangleFrame(matrixStack, true, true, circleStartAngle, shadeStartIndex + circleSides / 4, shadeStartIndex + circleSides / 2, circleSides, circleFrameThickness, circleLeftX, circleTopY, 138, frameTextureY, innerCircleDiameter, 68.0f, circleFrameThickness, 20, 256.0f);
            helper.drawTexturedElipseInsideRectangleFrame(matrixStack, false, false, circleStartAngle, shadeStartIndex + circleSides / 2, circleSides, circleSides, circleFrameThickness, circleLeftX, circleTopY, 0, frameTextureY, innerCircleDiameter, 73.0f, circleFrameThickness, circleSeamWidth, 256.0f);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)InterfaceRenderer.guiTextures);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)(scaledX + 9), (double)(scaledY + 9), 0.0);
        matrixStack.m_85841_(1.0f / minimapScale, 1.0f / minimapScale, 1.0f);
        int halfFrame = (int)((float)mapSize * minimapScale / 2.0f / 2.0f);
        matrixStack.m_85837_((double)halfFrame, (double)halfFrame, 0.0);
        int specH = specW = halfFrame + (int)(3.0f * minimapScale);
        boolean safeMode = this instanceof MinimapSafeModeRenderer;
        double playerX = minimap.getEntityRadar().getEntityX(this.mc.m_91288_(), partial);
        double playerY = minimap.getEntityRadar().getEntityY(this.mc.m_91288_(), partial);
        double playerZ = minimap.getEntityRadar().getEntityZ(this.mc.m_91288_(), partial);
        MultiBufferSource.BufferSource renderTypeBuffers = this.modMain.getInterfaceRenderer().getCustomVertexConsumers().getBetterPVPRenderTypeBuffers();
        MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers = minimapSession.getMultiTextureRenderTypeRenderers();
        double scaledZoom = this.zoom * (double)minimapScale / 2.0;
        if (!this.modMain.getSettings().compassOverEverything) {
            this.renderCompass(matrixStack, settings, renderTypeBuffers, specW, specH, halfFrame, ps, pc, circleShape, minimapScale);
        }
        this.minimapInterface.getOverMapRendererHandler().render(matrixStack, this.mc.m_91288_(), (Player)this.mc.f_91074_, playerX, playerY, playerZ, ps, pc, scaledZoom, cave, partial, null, this.modMain, helper, renderTypeBuffers, this.mc.f_91062_, multiTextureRenderTypeRenderers, specW, specH, halfFrame, halfFrame, circleShape, minimapScale);
        if (this.modMain.getSettings().compassOverEverything) {
            this.renderCompass(matrixStack, settings, renderTypeBuffers, specW, specH, halfFrame, ps, pc, circleShape, minimapScale);
        }
        renderTypeBuffers.m_109911_();
        matrixStack.m_85849_();
        RenderSystem.m_69478_();
        boolean bl2 = crosshairDisplayed = settings.mainEntityAs == 0 && !lockedNorth;
        if (crosshairDisplayed) {
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)(scaledX + 9), (double)(scaledY + 9), 0.0);
            matrixStack.m_85841_(0.5f, 0.5f, 1.0f);
            RenderSystem.m_69472_();
            matrixStack.m_85837_((double)(mapSize / 2), (double)(mapSize / 2), 0.0);
            RenderSystem.m_69411_((int)775, (int)0, (int)1, (int)0);
            this.getHelper().drawMyColoredRect(matrixStack, -5.0f, -1.0f, 5.0f, 1.0f);
            this.getHelper().drawMyColoredRect(matrixStack, -1.0f, 3.0f, 1.0f, 5.0f);
            this.getHelper().drawMyColoredRect(matrixStack, -1.0f, -5.0f, 1.0f, -3.0f);
            RenderSystem.m_69405_((int)770, (int)771);
            MinimapRadar minimapRadar = minimap.getEntityRadar();
            EntityRadarCategory mainEntityCategory = minimapRadar.getEntityCategoryManager().getRuleResolver().resolve(minimapRadar.getEntityCategoryManager().getRootCategory(), this.mc.m_91288_(), this.mc.f_91074_);
            if (mainEntityCategory == null) {
                mainEntityCategory = minimapRadar.getEntityCategoryManager().getRootCategory();
            }
            int crosshairColor = minimapRadar.getEntityColour((Player)this.mc.f_91074_, this.mc.m_91288_(), 0.0f, false, mainEntityCategory, 100, 100, false, mainEntityCategory.getSettingValue(EntityRadarCategorySettings.COLOR).intValue());
            RenderSystem.m_157429_((float)((float)(crosshairColor >> 16 & 0xFF) / 255.0f), (float)((float)(crosshairColor >> 8 & 0xFF) / 255.0f), (float)((float)(crosshairColor & 0xFF) / 255.0f), (float)1.0f);
            this.getHelper().drawMyColoredRect(matrixStack, 1.0f, -1.0f, 3.0f, 1.0f);
            this.getHelper().drawMyColoredRect(matrixStack, -3.0f, -1.0f, -1.0f, 1.0f);
            this.getHelper().drawMyColoredRect(matrixStack, -1.0f, 1.0f, 1.0f, 3.0f);
            this.getHelper().drawMyColoredRect(matrixStack, -1.0f, -3.0f, 1.0f, -1.0f);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69493_();
            RenderSystem.m_69478_();
            matrixStack.m_85849_();
        }
        double centerX = 2 * scaledX + 18 + mapSize / 2;
        double centerY = 2 * scaledY + 18 + mapSize / 2;
        matrixStack.m_85836_();
        matrixStack.m_85841_(0.5f, 0.5f, 1.0f);
        matrixStack.m_85837_(centerX, centerY, 0.0);
        this.mc.m_91097_().m_174784_(InterfaceRenderer.guiTextures);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        if (!safeMode && !crosshairDisplayed) {
            Entity mainEntity = this.mc.m_91288_();
            MinimapRadar radar = minimap.getEntityRadar();
            this.minimapInterface.getMinimapFBORenderer().renderMainEntityDot(matrixStack, minimap, (Player)this.mc.f_91074_, mainEntity, ps, pc, radar.getEntityX(mainEntity, partial), radar.getEntityZ(mainEntity, partial), partial, radar, lockedNorth, settings.getDotsStyle(), true, settings.debugEntityIcons, cave, settings.getDotNameScale(), settings, cvc.getBetterPVPRenderTypeBuffers(), 2.0f);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)InterfaceRenderer.guiTextures);
        RenderSystem.m_69478_();
        if (lockedNorth || settings.mainEntityAs == 2) {
            float b;
            float g;
            float r;
            float arrowAngle = lockedNorth ? this.mc.m_91288_().m_5675_(partial) : 180.0f;
            float arrowOpacity = (float)settings.playerArrowOpacity / 100.0f;
            if (arrowOpacity == 1.0f) {
                this.drawArrow(matrixStack, arrowAngle, 0.0, 1.0, 0.0f, 0.0f, 0.0f, 0.5f, settings);
            }
            if (settings.arrowColour != -1) {
                float[] c = ModSettings.arrowColours[settings.arrowColour];
                r = c[0];
                g = c[1];
                b = c[2];
                a = c[3];
            } else {
                int rgb = minimap.getEntityRadar().getTeamColour((Entity)this.mc.f_91074_);
                if (rgb != -1) {
                    r = (float)(rgb >> 16 & 0xFF) / 255.0f;
                    g = (float)(rgb >> 8 & 0xFF) / 255.0f;
                    b = (float)(rgb & 0xFF) / 255.0f;
                    a = 1.0f;
                } else {
                    float[] c = ModSettings.arrowColours[0];
                    r = c[0];
                    g = c[1];
                    b = c[2];
                    a = c[3];
                }
            }
            this.drawArrow(matrixStack, arrowAngle, 0.0, 0.0, r, g, b, a *= arrowOpacity, settings);
        }
        matrixStack.m_85849_();
        int depthClearerX = scaledX - 25;
        int depthClearerY = scaledY - 25;
        int depthClearerW = 18 + mapSize / 2 + 50;
        GlStateManager.m_84513_();
        GlStateManager.m_84323_((int)519);
        GlStateManager.m_84298_((boolean)true);
        GlStateManager.m_84300_((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        matrixStack.m_85837_(0.0, 0.0, -999.0);
        Gui.m_93172_((PoseStack)matrixStack, (int)depthClearerX, (int)depthClearerY, (int)(depthClearerX + depthClearerW), (int)(depthClearerY + depthClearerW), (int)-16777216);
        matrixStack.m_85837_(0.0, 0.0, 999.0);
        GlStateManager.m_84300_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.m_84323_((int)515);
        this.mc.m_91097_().m_174784_(InterfaceRenderer.guiTextures);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        int playerBlockX = OptimizedMath.myFloor(this.mc.m_91288_().m_20185_());
        int playerBlockY = OptimizedMath.myFloor(this.mc.m_91288_().m_20186_());
        int playerBlockZ = OptimizedMath.myFloor(this.mc.m_91288_().m_20189_());
        if (settings.getShowCoords()) {
            int interfaceSize = size;
            String coords = playerBlockX + ", " + playerBlockY + ", " + playerBlockZ;
            if (this.mc.f_91062_.m_92895_(coords) >= interfaceSize) {
                String stringLevel = "" + playerBlockY;
                coords = playerBlockX + ", " + playerBlockZ;
                underText.add((Component)Component.m_237113_((String)coords));
                underText.add((Component)Component.m_237113_((String)stringLevel));
            } else {
                underText.add((Component)Component.m_237113_((String)coords));
            }
        }
        BlockPos.MutableBlockPos pos = this.mutableBlockPos.m_122178_(playerBlockX, playerBlockY, playerBlockZ);
        if (settings.showDimensionName && (dimensionId = this.mc.f_91073_.m_46472_().m_135782_()) != null) {
            String dimensionName = dimensionId.m_135827_().equals("minecraft") ? dimensionId.m_135815_() : dimensionId.toString();
            underText.add((Component)Component.m_237113_((String)dimensionName));
        }
        if (settings.showBiome) {
            Holder biomeHolder = this.mc.f_91073_.m_204166_((BlockPos)pos);
            Biome biome = biomeHolder == null ? null : (Biome)biomeHolder.m_203334_();
            ResourceLocation biomeRL = biome == null ? null : this.mc.f_91073_.m_5962_().m_175515_(Registry.f_122885_).m_7981_((Object)biome);
            String biomeText = biomeRL == null ? I18n.m_118938_((String)"gui.xaero_unknown_biome", (Object[])new Object[0]) : I18n.m_118938_((String)("biome." + biomeRL.m_135827_() + "." + biomeRL.m_135815_()), (Object[])new Object[0]);
            this.addLineWordsUnderMinimap(underText, size, biomeText);
        }
        if (settings.displayWeatherInfo) {
            if (this.mc.f_91073_.m_46470_()) {
                underText.add((Component)Component.m_237115_((String)"gui.xaero_weather_thundering"));
            } else if (this.mc.f_91073_.m_46471_()) {
                underText.add((Component)Component.m_237115_((String)"gui.xaero_weather_raining"));
            }
        }
        if (settings.showLightLevel > 0) {
            int blockLight = this.mc.f_91073_.m_45517_(LightLayer.BLOCK, (BlockPos)pos);
            int skyLight = this.mc.f_91073_.m_45517_(LightLayer.SKY, (BlockPos)pos);
            if (settings.showLightLevel == 1) {
                underText.add((Component)Component.m_237110_((String)"gui.xaero_block_light_value", (Object[])new Object[]{blockLight}));
            } else if (settings.showLightLevel == 2) {
                underText.add((Component)Component.m_237110_((String)"gui.xaero_sky_light_value", (Object[])new Object[]{skyLight}));
            } else if (settings.showLightLevel == 3) {
                underText.add((Component)Component.m_237110_((String)"gui.xaero_all_light_value", (Object[])new Object[]{Math.max(blockLight, skyLight)}));
            } else {
                underText.add((Component)Component.m_237110_((String)"gui.xaero_both_light_value", (Object[])new Object[]{blockLight, skyLight}));
            }
        }
        if (settings.showTime != 0) {
            long totalTime = 6000L + this.mc.f_91073_.m_46468_();
            int dayNumber = (int)(totalTime / 24000L) + 1;
            int dayTimeSinceMidnight = (int)(totalTime % 24000L);
            int timeHours = dayTimeSinceMidnight / 1000;
            int minutes = (int)((double)(dayTimeSinceMidnight % 1000) / 1000.0 * 60.0);
            if ((settings.showTime - 1) % 2 == 0) {
                if (settings.showTime < 3) {
                    underText.add((Component)Component.m_237113_((String)(I18n.m_118938_((String)"gui.xaero_day", (Object[])new Object[0]) + String.format(" %d, %02d:%02d", dayNumber, timeHours, minutes))));
                } else {
                    underText.add((Component)Component.m_237113_((String)String.format("%02d:%02d", timeHours, minutes)));
                }
            } else {
                String half = "AM";
                if (timeHours >= 12) {
                    timeHours -= 12;
                    half = "PM";
                }
                if (timeHours == 0) {
                    timeHours = 12;
                }
                if (settings.showTime < 3) {
                    underText.add((Component)Component.m_237113_((String)(I18n.m_118938_((String)"gui.xaero_day", (Object[])new Object[0]) + String.format(" %d, %02d:%02d %s", dayNumber, timeHours, minutes, half))));
                } else {
                    underText.add((Component)Component.m_237113_((String)String.format("%02d:%02d %s", timeHours, minutes, half)));
                }
            }
        }
        if (minimap.getMinimapWriter().getDimensionHighlightHandler() != null) {
            minimap.getMinimapWriter().getDimensionHighlightHandler().addBlockHighlightTooltips(underText, playerBlockX, playerBlockZ, size, true);
        }
        if (minimap.getMinimapWriter().debugTotalTime) {
            underText.add((Component)Component.m_237113_((String)String.format("Min Time %d", minimap.getMinimapWriter().minTimeDebug)));
            underText.add((Component)Component.m_237113_((String)String.format("Average %d", minimap.getMinimapWriter().averageTimeDebug)));
            underText.add((Component)Component.m_237113_((String)String.format("Max Time %d", minimap.getMinimapWriter().maxTimeDebug)));
        }
        if (settings.showAngles) {
            underText.add((Component)Component.m_237113_((String)String.format("%.1f / %.1f", Float.valueOf(Mth.m_14177_((float)this.mc.m_91288_().m_146908_())), Float.valueOf(Mth.m_14177_((float)this.mc.m_91288_().m_146909_())))));
        }
        if (settings.lightOverlayType > 0) {
            underText.add((Component)Component.m_237115_((String)"gui.xaero_light_overlay_status"));
        }
        if (minimap.isManualCaveMode()) {
            this.addLineWordsUnderMinimap(underText, size, I18n.m_118938_((String)"gui.xaero_manual_cave_mode", (Object[])new Object[0]));
        }
        if ((waypointsManager = minimapSession.getWaypointsManager()).getCurrentWorld() != null && waypointsManager.getAutoWorld() != waypointsManager.getCurrentWorld()) {
            this.addLineWordsUnderMinimap(underText, size, I18n.m_118938_((String)"gui.xaero_using_custom_subworld", (Object[])new Object[]{waypointsManager.getCurrentWorld().getContainer().getSubName()}));
        }
        this.drawTextUnderMinimap(matrixStack, underText, scaledX, scaledY, height, size, mapScale, settings, cvc.getBetterPVPRenderTypeBuffers());
        matrixStack.m_85849_();
        Lighting.m_84931_();
    }

    private void renderCompass(PoseStack matrixStack, ModSettings settings, MultiBufferSource.BufferSource renderTypeBuffers, int specW, int specH, int halfFrame, double ps, double pc, boolean circleShape, float minimapScale) {
        VertexConsumer nameBgBuilder = renderTypeBuffers.m_6299_(CustomRenderTypes.RADAR_NAME_BGS);
        if (settings.compassLocation == 1) {
            halfFrame = (int)((float)halfFrame - 7.0f * minimapScale / 2.0f);
            int compassScale = (int)Math.ceil((float)settings.getCompassScale() * minimapScale / 2.0f);
            this.compassRenderer.drawCompass(matrixStack, this.getHelper(), halfFrame - 3 * compassScale, halfFrame - 3 * compassScale, ps, pc, 1.0, circleShape, compassScale, true, renderTypeBuffers, nameBgBuilder);
        } else if (settings.compassLocation == 2) {
            this.compassRenderer.drawCompass(matrixStack, this.helper, specW, specH, ps, pc, this.zoom, circleShape, minimapScale, false, renderTypeBuffers, null);
        }
    }

    private void addLineWordsUnderMinimap(ArrayList<Component> underText, int size, String line) {
        if (this.mc.f_91062_.m_92895_(line) <= size) {
            underText.add((Component)Component.m_237113_((String)line));
        } else {
            String[] words = line.split(" ");
            StringBuilder lineBuilder = new StringBuilder();
            for (int i = 0; i < words.length; ++i) {
                int lineWidth;
                int wordStart = lineBuilder.length();
                if (i > 0) {
                    lineBuilder.append(' ');
                }
                lineBuilder.append(words[i]);
                if (i == 0 || (lineWidth = this.mc.f_91062_.m_92895_(lineBuilder.toString())) <= size) continue;
                lineBuilder.delete(wordStart, lineBuilder.length());
                underText.add((Component)Component.m_237113_((String)lineBuilder.toString()));
                lineBuilder.delete(0, lineBuilder.length());
                lineBuilder.append(words[i]);
            }
            underText.add((Component)Component.m_237113_((String)lineBuilder.toString()));
        }
    }

    private void drawArrow(PoseStack matrixStack, float angle, double arrowX, double arrowY, float r, float g, float b, float a, ModSettings settings) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(arrowX, arrowY, 0.0);
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(angle));
        matrixStack.m_85841_((float)(0.5 * settings.arrowScale), (float)(0.5 * settings.arrowScale), 1.0f);
        int offsetY = -6;
        int h = 28;
        int ty = 0;
        matrixStack.m_85837_(-13.0, (double)offsetY, 0.0);
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)a);
        this.mc.f_91065_.m_93228_(matrixStack, 0, 0, 49, ty, 26, h);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.m_85849_();
    }

    public void drawTextUnderMinimap(PoseStack matrixStack, ArrayList<Component> underText, int scaledX, int scaledY, int height, int size, float mapScale, ModSettings settings, MultiBufferSource.BufferSource textRenderTypeBuffer) {
        int interfaceSize = size;
        int scaledHeight = (int)((float)height * mapScale);
        int align = settings.minimapTextAlign;
        for (int i = 0; i < underText.size(); ++i) {
            Component s = underText.get(i);
            int stringWidth = this.mc.f_91062_.m_92852_((FormattedText)s);
            boolean under = scaledY + interfaceSize / 2 < scaledHeight / 2;
            int stringY = scaledY + (under ? interfaceSize : -9) + i * 10 * (under ? 1 : -1);
            int stringX = scaledX + (align == 0 ? interfaceSize / 2 - stringWidth / 2 : (align == 1 ? 6 : interfaceSize - 6 - stringWidth));
            Misc.drawNormalText(matrixStack, s, (float)stringX, (float)stringY, -1, true, textRenderTypeBuffer);
        }
        textRenderTypeBuffer.m_109911_();
        underText.clear();
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
    }

    private float getSunBrightness() {
        return Mth.m_14036_((float)((this.mc.f_91073_.m_104805_(1.0f) - 0.2f) / 0.8f), (float)0.0f, (float)1.0f);
    }

    public MinimapRendererHelper getHelper() {
        return this.helper;
    }
}

