/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import com.google.common.base.Objects;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import xaero.common.IXaeroMinimap;
import xaero.common.MinimapLogs;
import xaero.common.XaeroMinimapSession;
import xaero.common.gui.ConfigSettingEntry;
import xaero.common.gui.ISettingEntry;
import xaero.common.gui.MyTinyButton;
import xaero.common.gui.ScreenBase;
import xaero.common.gui.widget.WidgetScreen;
import xaero.common.misc.KeySortableByOther;
import xaero.common.misc.Misc;
import xaero.common.settings.ModOptions;
import xaero.common.settings.ModSettings;

public abstract class GuiSettings
extends ScreenBase
implements WidgetScreen {
    protected int entriesPerPage = 12;
    protected ISettingEntry[] entries;
    protected String entryFilter = "";
    private boolean foundSomething;
    protected Component screenTitle;
    protected int page;
    protected int maxPage;
    private MyTinyButton nextButton;
    private MyTinyButton prevButton;
    private EditBox searchField;
    protected boolean canSearch = true;
    private boolean shouldRefocusSearch;
    private boolean shouldSaveRadar;

    public GuiSettings(IXaeroMinimap modMain, Component title, Screen backScreen, Screen escScreen) {
        super(modMain, backScreen, escScreen, title);
    }

    @Override
    public void m_7856_() {
        int verticalOffset;
        super.m_7856_();
        this.screenTitle = this.f_96539_;
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, this.f_96544_ / 6 + 168, 200, 20, (Component)Component.m_237110_((String)"gui.xaero_back", (Object[])new Object[0]), b -> this.goBack()));
        int n = verticalOffset = this.canSearch ? 24 : 0;
        if (this.entries != null) {
            boolean canEditIngameSettings = ModSettings.canEditIngameSettings();
            ArrayList<KeySortableByOther<ISettingEntry>> sortingList = new ArrayList<KeySortableByOther<ISettingEntry>>();
            String comparisonFilter = this.entryFilter.toLowerCase();
            for (int i = 0; i < this.entries.length; ++i) {
                int positionInEntryString;
                ISettingEntry entry = this.entries[i];
                String entrySearchString = entry.getStringForSearch().toLowerCase();
                if (entrySearchString == null || (positionInEntryString = entrySearchString.indexOf(comparisonFilter)) == -1) continue;
                KeySortableByOther<ISettingEntry> sortableEntry = new KeySortableByOther<ISettingEntry>(entry, Integer.valueOf(positionInEntryString));
                sortingList.add(sortableEntry);
            }
            ArrayList filteredEntries = sortingList.stream().sorted().map(KeySortableByOther::getKey).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
            if (!filteredEntries.isEmpty()) {
                this.foundSomething = true;
                this.maxPage = (int)Math.ceil((double)filteredEntries.size() / (double)this.entriesPerPage) - 1;
                if (this.page > this.maxPage) {
                    this.page = this.maxPage;
                }
                int firstEntry = this.entriesPerPage * this.page;
                int entryCount = Math.min(filteredEntries.size() - firstEntry, this.entriesPerPage);
                for (int i = 0; i < entryCount; ++i) {
                    ConfigSettingEntry settingEntry;
                    ISettingEntry entry = (ISettingEntry)filteredEntries.get(firstEntry + i);
                    AbstractWidget optionWidget = entry.createWidget(this.f_96543_ / 2 - 205 + i % 2 * 210, this.f_96544_ / 7 + verticalOffset + 24 * (i >> 1), 200, canEditIngameSettings);
                    this.m_142416_((GuiEventListener)optionWidget);
                    if (!(entry instanceof ConfigSettingEntry) || !(settingEntry = (ConfigSettingEntry)entry).usesWorldMapHardValue(this.modMain)) continue;
                    optionWidget.f_93623_ = false;
                }
            } else {
                this.foundSomething = false;
                this.page = 0;
                this.maxPage = 0;
            }
        }
        this.screenTitle = this.screenTitle.m_6879_().m_130946_(" (" + (this.page + 1) + "/" + (this.maxPage + 1) + ")");
        this.nextButton = new MyTinyButton(this.f_96543_ / 2 + 131, this.f_96544_ / 7 + 144 + verticalOffset, (Component)Component.m_237110_((String)"gui.xaero_next", (Object[])new Object[0]), b -> this.onNextButton());
        this.prevButton = new MyTinyButton(this.f_96543_ / 2 - 205, this.f_96544_ / 7 + 144 + verticalOffset, (Component)Component.m_237110_((String)"gui.xaero_previous", (Object[])new Object[0]), b -> this.onPrevButton());
        if (this.maxPage > 0) {
            this.m_142416_((GuiEventListener)this.nextButton);
            this.m_142416_((GuiEventListener)this.prevButton);
            this.nextButton.f_93623_ = this.page < this.maxPage;
            this.prevButton.f_93623_ = this.page > 0;
        }
        this.modMain.getWidgetScreenHandler().initialize(this, this.f_96543_, this.f_96544_);
        if (this.canSearch) {
            boolean shouldFocusSearch = this.shouldRefocusSearch;
            this.shouldRefocusSearch = false;
            int cursorPos = 0;
            if (shouldFocusSearch) {
                cursorPos = this.searchField.m_94207_();
            }
            this.searchField = new EditBox(this.f_96547_, this.f_96543_ / 2 - 100, this.f_96544_ / 7, 200, 20, (Component)Component.m_237115_((String)"gui.xaero_settings_search"));
            this.searchField.m_94144_(this.entryFilter);
            if (shouldFocusSearch) {
                this.m_7522_((GuiEventListener)this.searchField);
                this.searchField.m_94178_(true);
                this.searchField.m_94196_(cursorPos);
                this.searchField.m_94208_(cursorPos);
            }
            this.m_7787_((GuiEventListener)this.searchField);
        }
        this.f_96541_.f_91068_.m_90926_(true);
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.canSearch) {
            this.searchField.m_94120_();
        }
    }

    public void m_6305_(PoseStack matrixStack, int par1, int par2, float par3) {
        this.m_7333_(matrixStack);
        this.modMain.getWidgetScreenHandler().render(matrixStack, this, this.f_96543_, this.f_96544_, par1, par2, this.f_96541_.m_91268_().m_85449_());
        GuiComponent.m_93215_((PoseStack)matrixStack, (Font)this.f_96541_.f_91062_, (Component)this.screenTitle, (int)(this.f_96543_ / 2), (int)5, (int)0xFFFFFF);
        super.m_6305_(matrixStack, par1, par2, par3);
        if (this.canSearch) {
            if (!this.foundSomething) {
                GuiSettings.m_93208_((PoseStack)matrixStack, (Font)this.f_96541_.f_91062_, (String)I18n.m_118938_((String)"gui.xaero_settings_not_found", (Object[])new Object[0]), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 7 + 29), (int)0xFFFFFF);
            }
            if (!this.searchField.m_93696_() && this.searchField.m_94155_().isEmpty()) {
                Misc.setFieldText(this.searchField, I18n.m_118938_((String)"gui.xaero_settings_search_placeholder", (Object[])new Object[0]), -11184811);
                this.searchField.m_94192_(0);
            }
            this.searchField.m_6305_(matrixStack, par1, par2, par3);
            if (!this.searchField.m_93696_()) {
                Misc.setFieldText(this.searchField, this.entryFilter);
            }
        }
        this.renderTooltips(matrixStack, par1, par2, par3);
    }

    public void restoreFocus(int index) {
        if (index != -1) {
            try {
                GuiEventListener child = (GuiEventListener)this.m_6702_().get(index);
                this.m_7522_(child);
                child.m_5755_(true);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public int getIndex(GuiEventListener child) {
        List children = this.m_6702_();
        for (int i = 0; i < children.size(); ++i) {
            if (children.get(i) != child) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void addButtonVisible(AbstractWidget button) {
        this.m_142416_((GuiEventListener)button);
    }

    @Override
    public <S extends Screen> S getScreen() {
        return (S)this;
    }

    @Override
    protected void onExit(Screen screen) {
        try {
            this.modMain.getSettings().saveSettings();
        }
        catch (IOException e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
        if (this.shouldSaveRadar) {
            this.modMain.getEntityRadarCategoryManager().save();
        }
        super.onExit(screen);
    }

    public boolean m_7933_(int par1, int par2, int par3) {
        if (!(super.m_7933_(par1, par2, par3) || this.m_7222_() instanceof EditBox && ((EditBox)this.m_7222_()).m_93696_())) {
            if (Misc.inputMatchesKeyBinding(par1 != -1 ? InputConstants.Type.KEYSYM : InputConstants.Type.SCANCODE, par1 != -1 ? par1 : par2, (KeyMapping)this.modMain.getSettingsKey(), (IKeyConflictContext)KeyConflictContext.GUI)) {
                this.m_7379_();
                return true;
            }
            return false;
        }
        if (this.canSearch) {
            this.updateSearch();
        }
        return true;
    }

    public boolean m_5534_(char c, int i) {
        boolean result = super.m_5534_(c, i);
        if (this.canSearch) {
            this.updateSearch();
        }
        return result;
    }

    public boolean m_6375_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        this.modMain.getWidgetScreenHandler().handleClick(this, this.f_96543_, this.f_96544_, (int)p_mouseClicked_1_, (int)p_mouseClicked_3_, this.f_96541_.m_91268_().m_85449_());
        if (!super.m_6375_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_)) {
            if (Misc.inputMatchesKeyBinding(InputConstants.Type.MOUSE, p_mouseClicked_5_, (KeyMapping)this.modMain.getSettingsKey(), (IKeyConflictContext)KeyConflictContext.GUI)) {
                this.goBack();
                return true;
            }
            return false;
        }
        return true;
    }

    protected void onNextButton() {
        ++this.page;
        this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
    }

    protected void onPrevButton() {
        --this.page;
        this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
    }

    protected static ISettingEntry[] entriesFromOptions(ModOptions[] options) {
        ISettingEntry[] result = new ISettingEntry[options.length];
        for (int i = 0; i < options.length; ++i) {
            result[i] = new ConfigSettingEntry(options[i]);
        }
        return result;
    }

    protected void resetConfirmResult(boolean result, Screen parent, Screen escScreen) {
        if (result) {
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            if (minimapSession != null) {
                minimapSession.getMinimapProcessor().setToResetImage(true);
            }
            try {
                this.modMain.resetSettings();
                this.modMain.getSettings().saveSettings();
            }
            catch (IOException e) {
                MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
            }
            this.modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().resetEntityIcons();
        }
        this.modMain.getGuiHelper().onResetCancel(parent, escScreen);
    }

    public ISettingEntry[] getEntriesCopy() {
        if (this.entries == null) {
            return null;
        }
        ISettingEntry[] result = new ISettingEntry[this.entries.length];
        System.arraycopy(this.entries, 0, result, 0, this.entries.length);
        return result;
    }

    public void m_7522_(GuiEventListener guiEventListener) {
        GuiEventListener currentFocused = this.m_7222_();
        if (currentFocused != guiEventListener && currentFocused instanceof EditBox) {
            ((EditBox)currentFocused).m_94178_(false);
        }
        super.m_7522_(guiEventListener);
    }

    private void updateSearch() {
        String newValue;
        if (this.searchField.m_93696_() && !Objects.equal((Object)this.entryFilter, (Object)(newValue = this.searchField.m_94155_()))) {
            this.entryFilter = this.searchField.m_94155_();
            this.shouldRefocusSearch = true;
            this.page = 0;
            this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        }
    }

    public void setShouldSaveRadar() {
        this.shouldSaveRadar = true;
    }
}

