/*
 * Decompiled with CFR 0.152.
 */
package com.nick.chimes;

import com.nick.chimes.blocks.ChimesBlocks;
import com.nick.chimes.particle.ChimesParticles;
import com.nick.chimes.particle.LeafParticle;
import com.nick.chimes.renderer.AmethystBERenderer;
import com.nick.chimes.renderer.BambooBERenderer;
import com.nick.chimes.renderer.CopperBERenderer;
import com.nick.chimes.renderer.IronBERenderer;
import com.nick.chimes.sound.ChimesSounds;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="chimes")
public class Chimes {
    public static final String modid = "chimes";

    public Chimes() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::ClientSetup);
        ChimesBlocks.BLOCKS.register(modEventBus);
        ChimesBlocks.ITEMS.register(modEventBus);
        ChimesBlocks.BLOCK_ENTITIES.register(modEventBus);
        ChimesSounds.SOUND_EVENT.register(modEventBus);
        ChimesParticles.PARTICLES.register(modEventBus);
    }

    private void ClientSetup(FMLClientSetupEvent event) {
        RenderType CUTOUT = RenderType.m_110463_();
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ChimesBlocks.BAMBOO_WIND_CHIME_BLOCK_ENTITY.get()), BambooBERenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ChimesBlocks.IRON_WIND_CHIME_BLOCK_ENTITY.get()), IronBERenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ChimesBlocks.COPPER_WIND_CHIME_BLOCK_ENTITY.get()), CopperBERenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ChimesBlocks.AMETHYST_WIND_CHIME_BLOCK_ENTITY.get()), AmethystBERenderer::new);
        ForgeHooksClient.registerLayerDefinition((ModelLayerLocation)BambooBERenderer.BAMBOO_CHIMES_LAYER, BambooBERenderer::createBodyLayer);
        ForgeHooksClient.registerLayerDefinition((ModelLayerLocation)IronBERenderer.IRON_CHIMES_LAYER, IronBERenderer::createBodyLayer);
        ForgeHooksClient.registerLayerDefinition((ModelLayerLocation)CopperBERenderer.COPPER_CHIMES_LAYER, CopperBERenderer::createBodyLayer);
        ForgeHooksClient.registerLayerDefinition((ModelLayerLocation)AmethystBERenderer.AMETHYST_CHIMES_RENDERER, AmethystBERenderer::createBodyLayer);
    }

    @Mod.EventBusSubscriber(modid="chimes", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        @OnlyIn(value=Dist.CLIENT)
        public static void onParticleTypeRegistry(RegisterParticleProvidersEvent event) {
            event.register((ParticleType)ChimesParticles.LEAF.get(), LeafParticle.Factory::new);
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public static void onTextureStitchRegistry(TextureStitchEvent.Pre event) {
            event.addSprite(new ResourceLocation(Chimes.modid, "block/bamboo_chimes"));
            event.addSprite(new ResourceLocation(Chimes.modid, "block/bamboo_chimes_carved"));
            event.addSprite(new ResourceLocation(Chimes.modid, "block/metal_chimes"));
            event.addSprite(new ResourceLocation(Chimes.modid, "block/copper_chimes"));
            event.addSprite(new ResourceLocation(Chimes.modid, "block/amethyst_chimes"));
        }
    }
}

